/*
 * Decompiled with CFR 0.152.
 */
package put.idss.mlrules;

import java.io.Serializable;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Utils;

public class Rule
implements Serializable {
    static final long serialVersionUID = -1L;
    static final byte GREATER_EQUAL = 1;
    static final byte LESS_EQUAL = -1;
    static final double MINUS_INFINITY = -1.0E40;
    static final double PLUS_INFINITY = 1.0E40;
    double[] decision;
    public Vector<double[]> selectors = new Vector();
    Vector<Attribute> attributes = new Vector();
    private Attribute classAttribute = null;

    public Rule(Attribute classAttribute) {
        this.classAttribute = classAttribute;
    }

    public Rule(double attributeIndex, double cutValue, double direction, Attribute attribute, double[] decision, Attribute classAttribute) {
        this.addSelector(attributeIndex, cutValue, direction, attribute);
        this.setDecision(decision);
        this.classAttribute = classAttribute;
    }

    public void addSelector(double attributeIndex, double cutValue, double direction, Attribute attribute) {
        double[] selector2;
        for (double[] selector2 : this.selectors) {
            if (selector2[0] != attributeIndex) continue;
            if ((short)direction == 1) {
                selector2[1] = Math.max(cutValue, selector2[1]);
            } else {
                selector2[2] = Math.min(cutValue, selector2[2]);
            }
            return;
        }
        selector2 = new double[3];
        selector2[0] = attributeIndex;
        if ((short)direction == 1) {
            selector2[1] = cutValue;
            selector2[2] = 1.0E40;
        } else {
            selector2[1] = -1.0E40;
            selector2[2] = cutValue;
        }
        this.selectors.add(selector2);
        this.attributes.add(attribute);
    }

    public void setDecision(double[] decision) {
        this.decision = decision;
    }

    public double[] getDecision() {
        return this.decision;
    }

    public double[] classifyInstance(Instance instance) {
        boolean covered = true;
        for (double[] selector : this.selectors) {
            if (instance.isMissing((int)selector[0])) {
                covered = false;
                break;
            }
            if (!(selector[1] > instance.value((int)selector[0])) && !(selector[2] < instance.value((int)selector[0]))) continue;
            covered = false;
            break;
        }
        if (covered) {
            return this.decision;
        }
        return null;
    }

    public String toString() {
        StringBuffer string = new StringBuffer("Rule: \n");
        int i = 0;
        while (i < this.selectors.size()) {
            String sign;
            double[] selector = this.selectors.get(i);
            if (this.attributes.get(i).isNominal()) {
                sign = selector[1] == -1.0E40 ? this.attributes.get(i).value(0) : this.attributes.get(i).value(1);
                string.append("  " + this.attributes.get(i).name() + " is " + sign + "\n");
            } else {
                sign = selector[1] == -1.0E40 ? " <= " + Utils.roundDouble((double)selector[2], (int)3) : (selector[2] == 1.0E40 ? " >= " + Utils.roundDouble((double)selector[1], (int)3) : " in [" + Utils.roundDouble((double)selector[1], (int)3) + "," + Utils.roundDouble((double)selector[2], (int)3) + "]");
                string.append("  " + this.attributes.get(i).name() + sign + "\n");
            }
            ++i;
        }
        string.append("=> vote for class ");
        i = 0;
        while (this.decision[i] < 0.0) {
            ++i;
        }
        string.append(String.valueOf(this.classAttribute.value(i)) + " with weight " + this.decision[i] + "\n");
        return string.toString();
    }
}

