/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.equinox.internal.provisional.p2.core.eventbus;

import java.util.EventObject;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;

/**
 * The bus for events related to provisioning. This service can be used to register
 * a listener to receive provisioning events, or to broadcast events.
 */
public interface IProvisioningEventBus extends EventDispatcher {
	/**
	 * The name used for obtaining a reference to the event bus service.
	 */
	public static final String SERVICE_NAME = IProvisioningEventBus.class.getName();

	public abstract void addListener(ProvisioningListener toAdd);

	public abstract void removeListener(ProvisioningListener toRemove);

	public abstract void publishEvent(EventObject event);

	public abstract void close();

}