/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package pl.poznan.put.qjunit.view;

import java.text.MessageFormat;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;

/**
 * Open a class on a Test method.
 */
public class OpenTestAction extends OpenEditorAction {
	
	private String fMethodName;
	private ISourceRange fRange;
	private int fLineNumber;
	
	public OpenTestAction(MutationsView testRunner, String className, String method, int lineNumber) {
		this(testRunner, className, method, true);
		fLineNumber = lineNumber;
	}
	
	public OpenTestAction(MutationsView testRunner, String className, String method) {
		this(testRunner, className, method, true);
	}
	
	public OpenTestAction(MutationsView testRunner, String className) {
		this(testRunner, className, null, 0);
	}

	public OpenTestAction(MutationsView testRunner, String className, String method, boolean activate) {
		super(testRunner, className, activate);
		fMethodName= method;
	}

	protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
		IType type= findType(project, className);
		if (type == null) 
			return null;
		
		if (fMethodName == null)
			return type;
			
		IMethod method= findMethod(type);
		if (method == null) {
			ITypeHierarchy typeHierarchy= type.newSupertypeHierarchy(null);
			IType[] types= typeHierarchy.getAllSuperclasses(type);
			for (int i= 0; i < types.length; i++) {
				method= findMethod(types[i]);
				if (method != null)
					break;
			}
		}
		if (method == null) {
			String title= "Go To Test"; 
			String message= MessageFormat.format("Method '{0}' not found. Opening test class.", new String[] { fMethodName}); 
			MessageDialog.openInformation(getShell(), title, message);
			return type;
		}
		fRange= method.getNameRange();
		return method;
	}
	
	IMethod findMethod(IType type) {
		IStatus status= JavaConventions.validateMethodName(fMethodName, JavaCore.VERSION_1_3, JavaCore.VERSION_1_3);
		if (! status.isOK())
			return null;
		IMethod method= type.getMethod(fMethodName, new String[0]);
		if (method != null && method.exists())
			return method;
		return null;
	}
	
	protected void reveal(ITextEditor textEditor) {
		if (fLineNumber > 0) {
			try {
				IDocument document= textEditor.getDocumentProvider().getDocument(textEditor.getEditorInput());
				textEditor.selectAndReveal(document.getLineOffset(fLineNumber-1), document.getLineLength(fLineNumber-1));
			} catch (BadLocationException x) {
				// marker refers to invalid text position -> do nothing
			}
		} else if (fRange != null) {
			textEditor.selectAndReveal(fRange.getOffset(), fRange.getLength());
		}
	}

}
