package pl.poznan.put.qjunit.view;

import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestSuiteElement;
import org.eclipse.jdt.junit.model.ITestElement.Result;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.SharedImages;
import pl.poznan.put.qjunit.model.ComplexResponse;
import pl.poznan.put.qjunit.model.MutationElement;
import pl.poznan.put.qjunit.model.MutationOperator;
import pl.poznan.put.qjunit.model.MutationResult;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.model.TestCaseAdapter;

public class MutationsViewLabelProvider extends BaseLabelProvider implements ITableLabelProvider {

	private IMemento fMemento;
	
	public MutationsViewLabelProvider(IMemento memento) {
		fMemento = memento;
	}

	public Image getColumnImage(Object element, int columnIndex) {
		if (columnIndex != 0)
			return null;
		
		// TODO This should be based on mutations results, not tests results
		if (element instanceof ITestSuiteElement) {
			Result result = ((ITestSuiteElement) element).getTestResult(true);
			if (result.equals(Result.ERROR)) {
				return SharedImages.getImage(SharedImages.IMG_SUITE_ERR);
			} else if (result.equals(Result.FAILURE)) {
				return SharedImages.getImage(SharedImages.IMG_SUITE_FAIL);
			} else if (result.equals(Result.OK)) {
				return SharedImages.getImage(SharedImages.IMG_SUITE_OK);
			} 
		}
		
		if (element instanceof ITestCaseElement) {
			ITestCaseElement tc = (ITestCaseElement) element;
			MutationSession session = Activator.getMutationModel().getMutationSession();
			if (session != null) {
				element = session.getTestCaseAdapter(tc.getTestClassName(), tc.getTestMethodName());
			}
		}
		
		if (element instanceof TestCaseAdapter) {
			TestCaseAdapter tca = (TestCaseAdapter) element;
			
			if (tca.getMutationsAlive() > 0) {
				return SharedImages.getImage(SharedImages.IMG_MUTATION_FAIL);
			} else {
				return SharedImages.getImage(SharedImages.IMG_MUTATION_OK);
			}
		}
		
		if (element instanceof MutationElement) {
			MutationElement mutationElement = (MutationElement) element;
			if (mutationElement.getResultsAlive() > 0) {
				return SharedImages.getImage(SharedImages.IMG_MUTATION_FAIL);
			} else {
				return SharedImages.getImage(SharedImages.IMG_MUTATION_OK);
			}
		}
		
		if (element instanceof MutationResult) {
			MutationResult mutationResult = (MutationResult) element;
			
			String result = mutationResult.getResult();
			if (result.equals(MutationResult.ERROR)) {
				return SharedImages.getImage(SharedImages.IMG_TEST_ERR);
			} else if (result.equals(MutationResult.FAILURE)) {
				return SharedImages.getImage(SharedImages.IMG_TEST_FAIL);
			} else if (result.equals(MutationResult.OK)) {
				return SharedImages.getImage(SharedImages.IMG_TEST_OK);
			}
		}
		
		if (element instanceof ComplexResponse) {
			return SharedImages.getImage(SharedImages.IMG_FIELD);
		}
		
		if (element.getClass().getName().startsWith("java.lang")) { // primitive types at top
			return SharedImages.getImage(SharedImages.IMG_FIELD);
		}
		
		return null;
	}
	
	public String getColumnText(Object element, int columnIndex) {
		if (element instanceof MutationOperator) {
			MutationOperator oper = (MutationOperator) element;
			
			switch (columnIndex) {
			case 0:
				return oper.getName();
			case 1:
				return oper.getAliveCount() + " / " + oper.getResultsCount();
			}
		}
		
		if (element instanceof ITestSuiteElement) {
			ITestSuiteElement tec = (ITestSuiteElement)element;
			return columnIndex == 0 ? tec.getSuiteTypeName() : "";
		}
		
		if (element instanceof ITestCaseElement) {
			ITestCaseElement tce = (ITestCaseElement)element;
			
			MutationSession session = Activator.getMutationModel().getMutationSession();
			if (session == null) {
				return "";
			}
			element = session.getTestCaseAdapter(tce.getTestClassName(), tce.getTestMethodName());
		}
		
		if (element instanceof TestCaseAdapter) {
			TestCaseAdapter tca = (TestCaseAdapter)element;
			switch (columnIndex) {
			case 0:
				return tca.getClassName() + "." + tca.getMethodName();
			case 1:
				return tca.getMutationsAlive() +  " / " + tca.getMutationsCount();
			default:
				return "";
			}
			
		}
		
		if (element instanceof MutationElement) {
			MutationElement mutation = (MutationElement) element;
			switch (columnIndex) {
			case 0:
				return mutation.getSignature();
			case 1:
				return mutation.getResultsAlive() + " / " + mutation.getResults().length;
			default:
				return "";
			}
		}
		
		if (element instanceof MutationResult) {
			MutationResult result = (MutationResult) element;
			
			if (columnIndex == 0) {
				if (result.getResponse() instanceof ComplexResponse) {
					return ((ComplexResponse)result.getResponse()).getType();
				} else {
					return "Response = "+result.getResponse();
				}
			} else if (columnIndex == 2) {
				return result.getGenerator();
			}
		}
		
		if (element instanceof ComplexResponse) {
			ComplexResponse result = (ComplexResponse) element;
			
			if (columnIndex == 0) {
				StringBuffer sb = new StringBuffer();
				sb.append(result.getName());
				if (result.getType().startsWith("java.lang")) {
					sb.append(" = ");
					sb.append(result.getValue());
				} else {
					sb.append(" : ");
					sb.append(result.getType());
				}
				
				return  sb.toString();
			} else {
				return "";
			}
		}
		
		if (columnIndex == 0) {
			return element == null ? "" : element.toString();
		} else {
			return "";
		}
	}

}
