package pl.poznan.put.qjunit.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElementContainer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.model.ComplexResponse;
import pl.poznan.put.qjunit.model.MutationElement;
import pl.poznan.put.qjunit.model.MutationModel;
import pl.poznan.put.qjunit.model.MutationOperator;
import pl.poznan.put.qjunit.model.MutationResult;
import pl.poznan.put.qjunit.model.MutationSession;
import pl.poznan.put.qjunit.model.TestCaseAdapter;

public class MutationsViewContentProvider implements ITreeContentProvider {

	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof ITestElementContainer) {
			return ((ITestElementContainer)parentElement).getChildren();
		}
		
		if (parentElement instanceof MutationOperator) {
			return ((MutationOperator) parentElement).getResults();
		}
		
		if (parentElement instanceof ITestCaseElement) {
			ITestCaseElement tc = (ITestCaseElement) parentElement;
			MutationSession session = Activator.getMutationModel().getMutationSession();
			if (session == null) {
				return null;
			}
			
			parentElement = session.getTestCaseAdapter(tc.getTestClassName(), tc.getTestMethodName());
		}
		
		if (parentElement instanceof TestCaseAdapter) {
			TestCaseAdapter tc = (TestCaseAdapter) parentElement;
			
			return tc.getMutations();
		}
		
		if (parentElement instanceof MutationElement) {
			MutationElement result = (MutationElement) parentElement;
			
			Object[] a = result.getLearned();
			Object[] b = result.getResults();
			
			Object[] c = new Object[a.length + b.length];
			System.arraycopy(a, 0, c, 0, a.length);
			System.arraycopy(b, 0, c, a.length, b.length);
			
			return c;
		}
		
		if (parentElement instanceof MutationResult) {
			MutationResult result = (MutationResult) parentElement;
			List elements = new ArrayList();
			
			Object response = result.getResponse();
			if (response instanceof ComplexResponse) {
				elements.add(response);
			}
			
			if (!" ".equals(result.getResultMessage())) { // FIXME empty result message should be empty, but " " is used instead for correct parsing by StringTokenizer in MutationSession
				elements.add(result.getResultMessage());
			}
			
			if (elements.size() == 0) {
				return null;
			} else {
				return (Object[]) elements.toArray(new Object[elements.size()]);
			}
		}
		
		if (parentElement instanceof ComplexResponse) {
			return ((ComplexResponse)parentElement).getChildren();
		}
		
		return null;
	}

	public Object getParent(Object element) {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean hasChildren(Object element) {
		Object[] children = getChildren(element);
		return ((children != null) && (children.length > 0));
	}

	public Object[] getElements(Object inputElement) {
		if (inputElement.getClass().isArray()) {
			return (Object[]) inputElement;
		}
		
		if (inputElement instanceof MutationModel) {
			MutationSession session = ((MutationModel)inputElement).getMutationSession();
			if (session != null) {
				return session.getTestCases();
			}
		}
		
		return new Object[0];
	}

	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub

	}

}
