package pl.poznan.put.qjunit.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TestCaseAdapter {

	private String className;
	private  String methodName;
	private List elements = new ArrayList();
	
	public TestCaseAdapter(String className, String methodName) {
		this.className = className;
		this.methodName = methodName;
	}

	public String getClassName() {
		return className;
	}

	public String getMethodName() {
		return methodName;
	}
	
	public void put(MutationElement element) {
		elements.add(element);
	}
	
	public MutationElement[] getMutations() {
		return (MutationElement[]) elements.toArray(new MutationElement[elements.size()]);
	}
	
	public int getMutationsAlive() {
		int mutationsAlive = 0;
		for (Iterator i = elements.iterator(); i.hasNext(); ) {
			int alive = ((MutationElement) i.next()).getResultsAlive();
			mutationsAlive += alive;
		}
	
		return mutationsAlive;
	}
	
	public int getMutationsCount() {
		int mutationsCount = 0;
		for (Iterator i = elements.iterator(); i.hasNext(); ) {
			mutationsCount += ((MutationElement) i.next()).getResults().length;
		}
		
		return mutationsCount;
	}

	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((className == null) ? 0 : className.hashCode());
		result = prime * result
				+ ((methodName == null) ? 0 : methodName.hashCode());
		return result;
	}

	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TestCaseAdapter other = (TestCaseAdapter) obj;
		if (className == null) {
			if (other.className != null)
				return false;
		} else if (!className.equals(other.className))
			return false;
		if (methodName == null) {
			if (other.methodName != null)
				return false;
		} else if (!methodName.equals(other.methodName))
			return false;
		return true;
	}
}
