package pl.poznan.put.qjunit.model;

public class ObjectDeserializer {

	int index;
	
	/**
	 * May throw StringIndexOutOfBoundsException, NumberFormatException for incorrect message.
	 * 
	 * @param name
	 * @param string
	 * @param type
	 * @return
	 */
	public Object create(String name, String string, int type) {
		index = 0;
		return _create(name, string, type);
	}
	
	protected Object _create(String name, String string, int type) {
		try {
			switch (type) {
			case ComplexResponse.TYPE_BOOLEAN:
				return new Boolean(readValue(string));
			case ComplexResponse.TYPE_CHAR:
				return new Character(readValue(string).charAt(0));
			case ComplexResponse.TYPE_BYTE:
				return new Byte(readValue(string));
			case ComplexResponse.TYPE_INT:
				return new Integer(readValue(string));
			case ComplexResponse.TYPE_LONG:
				return new Long(readValue(string));
			case ComplexResponse.TYPE_SHORT:
				return new Short(readValue(string));
			case ComplexResponse.TYPE_DOUBLE:
				return new Double(readValue(string));
			case ComplexResponse.TYPE_FLOAT:
				return new Float(readValue(string));
			}
		} catch (NumberFormatException e) {
			// keep it a string
			return new String(string);
		};
		
		if (type == ComplexResponse.TYPE_OBJECT) { // it's either object, or object's field of unknown type
			String className = null;
			Object value = null;
			ComplexResponse[] children = null;
			
			if (! Character.isDigit(string.charAt(index))) {
				int sep = string.indexOf(' ', index);
				className = string.substring(index, sep);

				index = sep + 1; // + ' '
				
				sep = string.indexOf(' ', index);
				if (sep == -1) // end of string
					sep = string.length();
						
				int fieldsCount = Integer.parseInt(string.substring(index, sep));
				
				index = sep;
				
				if (fieldsCount > 0) {
					children = new ComplexResponse[fieldsCount];
					for (int i = 0; i < children.length; i++) {
						children[i] = readField(string); 
					}
				}
			} else {
				value = readValue(string);
			}
			
			ComplexResponse response = new ComplexResponse(name, value, type, className, children);
			
			return response;
		}
		
		return new String(string);
	}
	
	protected String readValue(String s) {
		int separator = s.indexOf(' ', index);
		int length = Integer.parseInt(s.substring(index, separator));
		
		index = separator + 1 + length;
		return s.substring(separator + 1, index);
	}
	
	protected ComplexResponse readField(String string) {
		index++; // skip ' '
		int sep = string.indexOf(' ', index);
		String name = string.substring(index, sep);
		
		index = sep + 1;
		
		return (ComplexResponse) _create(name, string, ComplexResponse.TYPE_OBJECT);
	}
}
