package pl.poznan.put.qjunit.model;

public class MutationResult {

	// see pl.poznan.put.qjunit.runtime.MutationTestListener for where these strings are defined
	public static final String OK = "ok";
	public static final String FAILURE = "failure";
	public static final String ERROR = "error";
	
	private Object response;
	
	private String result;
	
	private String resultMessage;
	
	private long time;
	
	private MutationElement parent;
	
	private String generator;

	public MutationResult(MutationElement parent, String generator, Object response, String result, String resultMessage, long time) {
		this.parent = parent;
		this.response = response;
		this.result = result;
		this.time = time;
		this.generator = generator;
		this.resultMessage = resultMessage;
	}
	
	public String getGenerator() {
		return generator;
	}
	
	public Object getResponse() {
		return response;
	}

	public String getResult() {
		return result;
	}

	public long getTime() {
		return time;
	}
	
	public MutationElement getParent() {
		return parent;
	}
	
	public String getResultMessage() {
		return resultMessage;
	}
}
