package pl.poznan.put.qjunit.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MutationOperator {

	private String name;
	
	private List results = new ArrayList();
	
	public MutationOperator(String name) {
		this.name = name;
	}
	
	public void addResult(MutationResult result) {
		results.add(result);
	}
	
	public String getName() {
		return name;
	}
	
	public int getResultsCount() {
		return results.size();
	}
	
	public int getAliveCount() {
		int alive = 0;
		
		for (Iterator i = results.iterator(); i.hasNext(); ) {
			MutationResult result = (MutationResult) i.next();
			alive += MutationResult.OK.equals(result.getResult()) ? 1 : 0;
		}
		
		return alive;
	}
	
	public MutationResult[] getResults() {
		return (MutationResult[]) results.toArray(new MutationResult[results.size()]);
	}
}
