package pl.poznan.put.qjunit.model;

/**
 * Represents a place in test code where responses were injected.
 *
 */
public class MutationElement {

	public static final String FAILURE = "failure";

	public static final String OK = "ok";

	private String className;
	
	private String methodName;

	private int responseType;

	private String fileName;

	private int line;

	private Object[] learned;

	private MutationResult[] results;
	
	private String signature;
	
	public MutationElement(String className, String methodName) {
		this.className = className;
		this.methodName = methodName;
	}
	
	public String getClassName() {
		return className;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setResponseType(int parseInt) {
		responseType = parseInt;
		
	}

	public void setFileName(String nextToken) {
		fileName = nextToken;
	}

	public void setLine(int parseInt) {
		line = parseInt;
	}

	public void setLearned(Object[] readArray) {
		learned = readArray;
	}

	public void setResults(MutationResult[] mutationResults) {
		results = mutationResults;
	}
	
	public MutationResult[] getResults() {
		return results;
	}

	public int getResponseType() {
		return responseType;
	}

	public String getFileName() {
		return fileName;
	}

	public int getLine() {
		return line;
	}

	public Object[] getLearned() {
		return learned;
	}

	/**
	 * Returns aggregated result of this mutation:
	 * if there's at least one PASSED mutation result, then this mutation failed
	 * @return
	 */
	public int getResultsAlive() {
		MutationResult[] results = getResults();
		if (results == null)
			return 0;
		
		int alive = 0;
		for (int i = 0; i < results.length; i++) {
			if (MutationResult.OK.equals(results[i].getResult()))
				alive++;
		}
		
		return alive;
	}
	
	public void setSignature(String signature) {
		this.signature = signature;
		
	}

	public String getSignature() {
		return signature;
	}
}
