package pl.poznan.put.qjunit.model;

public class ComplexResponse {

	static final int TYPE_BOOLEAN = 0;
	static final int TYPE_CHAR    = 1;
	static final int TYPE_BYTE    = 2;
	static final int TYPE_INT     = 3;
	static final int TYPE_LONG    = 4;
	static final int TYPE_SHORT   = 5;
	static final int TYPE_DOUBLE  = 6;
	static final int TYPE_FLOAT   = 7;
	static final int TYPE_OBJECT  = 8;
	
	private String name;
	
	private Object value;
	
	private ComplexResponse[] children;
	
	private int type;
	private String typeName;
	
	public ComplexResponse(String name, Object value, int type, String typeName, ComplexResponse[] children) {
		this.name = name;
		this.value = value;
		this.type = type;
		this.typeName = typeName;
		this.children = children;
	}
	
	public String getName() {
		return name;
	}
	
	public Object getValue() {
		return value;
	}
	
	public String getType() {
		if (typeName != null)
			return typeName;
		
		switch (type) {
		case TYPE_BOOLEAN:
			return Boolean.class.getName();
		case TYPE_CHAR:
			return Character.class.getName();
		case TYPE_BYTE:
			return Byte.class.getName();
		case TYPE_INT:
			return Integer.class.getName();
		case TYPE_LONG:
			return Long.class.getName();
		case TYPE_SHORT:
			return Short.class.getName();
		case TYPE_DOUBLE:
			return Double.class.getName();
		case TYPE_FLOAT:
			return Float.class.getName();
		}
		
		return Object.class.getName();
	}
	
	/**
	 * 
	 * @return children or null
	 */
	public ComplexResponse[] getChildren() {
		return children;
	}
}
