package pl.poznan.put.qjunit.core;

import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.SocketUtil;

import pl.poznan.put.qjunit.Activator;

public class LaunchConfigurationDelegate extends JUnitLaunchConfigurationDelegate {

	public static final String ATTR_PORT = Activator.PLUGIN_ID + ".PORT";

	private int fPort;
	
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		
		fPort = SocketUtil.findFreePort();
		if (fPort == -1) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, 0, "No free ports avaialble", null);
			throw new CoreException(status); 
		}
		
		launch.setAttribute(ATTR_PORT, String.valueOf(fPort));
		
		super.launch(configuration, mode, launch, monitor);
	}
	
	protected void collectExecutionArguments(ILaunchConfiguration configuration, List/*String*/ vmArguments, List/*String*/ programArguments) throws CoreException {
		super.collectExecutionArguments(configuration, vmArguments, programArguments);
		
		programArguments.add("-mutation.port"); //$NON-NLS-1$
		programArguments.add(String.valueOf(fPort));
		
		// XXX DEBUG
		vmArguments.add("-XX:+HeapDumpOnOutOfMemoryError");
	}

	public String verifyMainTypeName(ILaunchConfiguration configuration)
			throws CoreException {
		return "pl.poznan.put.qjunit.runtime.QRemoteTestRunner";
	}

	public String[] getClasspath(ILaunchConfiguration configuration)
			throws CoreException {
		String[] classpath = super.getClasspath(configuration);
		
		String projectName = getJavaProjectName(configuration);
		
		String out = InstrumentationHelper.getInstrumentedPath(configuration, classpath[0], classpath, projectName);
		classpath[0] = out;
		
		return classpath;
	}
}
