package pl.poznan.put.qjunit.core;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.aspectj.ajde.core.AjCompiler;
import org.aspectj.ajde.core.IBuildProgressMonitor;
import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.bridge.IMessage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;

import pl.poznan.put.qjunit.Activator;
import pl.poznan.put.qjunit.ajcompiler.BuildMessageHandler;
import pl.poznan.put.qjunit.ajcompiler.BuildProgressMonitor;
import pl.poznan.put.qjunit.ajcompiler.CompilerConfiguration;

public class InstrumentationHelper {

	protected static boolean hasInstrumentation(String projectName) {
		String outPath = getWovenBinPath(projectName);
		
		File file = new File(outPath);
		
		return file.exists();
	}
	
	public static void removeInstrumentation(String projectName) {
		String outPath = getWovenBinPath(projectName);
		File file = new File(outPath);
		delete(file);
	}
	
	public static String getInstrumentedPath(ILaunchConfiguration configuration, String inPath, String[] classpath, String projectName) throws CoreException {
		String outPath = getWovenBinPath(projectName);
		
		if (! hasInstrumentation(projectName)) {
			// TODO #4 wrap compilation in job + show progress
			// TODO #1 Hunt OutOfMemoryError in compiler 
			prepareDir(outPath);
			classpath = prepareCompilerClasspath(configuration, classpath);
			weaveAspects(inPath, classpath, outPath);
		}
		
		return outPath;
	}
	
	protected static String weaveAspects(String inPath, String[] classpath, String outPath) throws CoreException {
		String aspectPath = FileUtils.getBundleJarPath("pl.poznan.put.qjunit.runtime.interceptor", null);
		
		BuildMessageHandler buildMessageHandler = new BuildMessageHandler();
		IBuildProgressMonitor buildProgressMonitor = new BuildProgressMonitor();
		ICompilerConfiguration compilerConfiguration = new CompilerConfiguration(inPath, classpath, aspectPath, outPath);
		AjCompiler compiler = new AjCompiler(outPath, compilerConfiguration, buildProgressMonitor, buildMessageHandler);
		compiler.buildFresh();
		compiler.clearLastState(); // this doesn't work
		
		if (buildMessageHandler.hasErrors()) {
			IMessage[] ms = buildMessageHandler.getMessages();
			
			List errors = new ArrayList();
			
			for (int i = 0; i < ms.length; i++) {
				if (! ms[i].getKind().isSameOrLessThan(IMessage.WARNING))
					errors.add(new Status(IStatus.ERROR, Activator.PLUGIN_ID, ms[i].getMessage(), ms[i].getThrown()));
			}
			
			if (errors.size() > 1) {
				throw new CoreException(new MultiStatus(Activator.PLUGIN_ID, 0, (IStatus[]) errors.toArray(new IStatus[errors.size()]), "Multiple errors during tests instrumentation", null));
			} else if (errors.size() == 1) {
				throw new CoreException((IStatus) errors.get(0));
			}
		}
	    
		return outPath;
	}
	
	protected static String[] prepareCompilerClasspath(ILaunchConfiguration configuration, String[] classpath) throws CoreException {
		IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath(configuration);
		entries = JavaRuntime.resolveRuntimeClasspath(entries, configuration);
		
		// TODO #5 OPTIMIZE BUILDING CLASSPATH FOR DIFFICULT PROJECT SETTUPS
		List list = new ArrayList();
		for (int i = 0; i < entries.length; i++) {
				list.add(entries[i].getLocation());
		}
		
		list.add(FileUtils.getBundleJarPath("org.aspectj.runtime", "/aspectjrt.jar"));
		list.add(FileUtils.getBundleJarPath("pl.poznan.put.qjunit.runtime.interceptor", null));
				
		return (String[]) list.toArray(new String[list.size()]);
	}
	
	private static boolean prepareDir(String pathname) {
		File f = new File(pathname);
		
		if (! f.exists()) {
			return f.mkdirs();
		} else {
			if (f.isDirectory()) {
				return delete(f);
			} else {
				f.delete();
				return f.mkdir();
			}
		}
	}
	
	private static boolean delete(File f) {
		String[] list = f.list();
		
		if (f.isDirectory()) {
			for (int i = 0; i < list.length; i++) {
				delete(new File(f, list[i]));
			}
		}
	
		return f.delete();
	}
	
	protected static String getWovenBinPath(String projectName) {
		IPath path = Activator.getDefault().getStateLocation();
		
		return path.toOSString() + "/bin/" + projectName;
	}
}
