package pl.poznan.put.qjunit.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

import pl.poznan.put.qjunit.Activator;


public class FileUtils {

	/**
	 * Returns a set of all files in given path
	 * @param path
	 * @return list of org.eclipse.core.runtime.IPath
	 */
	public static Set findFiles(String path) {
		Set result = new HashSet();
		
		try {
			recursiveFindFiles(result, new File(path));
		} catch (IOException e) {
			Activator.log(e);
		}
		
		return result;
	}

	/**
	 * Helper recursive method for {@link findFiles}
	 * @param set of java.io.File
	 * @param path
	 * @throws IOException 
	 */
	private static void recursiveFindFiles(Set set, File path) throws IOException {
		if (path.isDirectory()) {
			String files[] = path.list();
			
			for (int i = 0; i < files.length; i++) {
				recursiveFindFiles(set, new File(path, files[i]));
			}
			
		} else {
			set.add(new Path(path.getCanonicalPath()));
		}
		
	}

	/**
	 * Resolves bundle name and path inside that bundle to file path
	 * @param bundleName
	 * @param path path inside bundle, starting with "/"
	 * @return file path or null
	 */
	public static String getBundleJarPath(String bundleName, String path) {
		Bundle bundle = Platform.getBundle(bundleName);
		
		if (path == null) {
			path = "/";
		}
		
		try {
			URL entry = null;
			if (Platform.inDevelopmentMode()) {
				entry = bundle.getEntry("/bin" + path);
			}
			
			// inDevelopmentMode was disabled, or failed
			if (entry == null) {
				entry = bundle.getEntry(path);
			}
			
			return FileLocator.toFileURL(entry).getFile();
		} catch (MalformedURLException e) {
			Activator.log(e);
		} catch (IOException e) {
			Activator.log(e);
		}
		
		return null;
	}

}
