package pl.poznan.put.qjunit.ajcompiler;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.aspectj.ajde.core.ICompilerConfiguration;
import org.aspectj.ajde.core.IOutputLocationManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

import pl.poznan.put.qjunit.core.FileUtils;


public class CompilerConfiguration implements ICompilerConfiguration {

	private Set inPath;
	private Map resourcesPath;
	private String[] classpath;
	private File aspectPath;
	private IOutputLocationManager outPath;
	
	public CompilerConfiguration(String inPath, String[] classpath, String aspectPath, String outPath) {
		this.classpath = classpath;
		this.aspectPath = new File(aspectPath);
		this.outPath = new OutLocationManager(outPath);
		this.inPath = Collections.singleton( new File(inPath));
		
		IPath path = new Path(inPath);
		
		Set inFiles = FileUtils.findFiles(inPath);
		this.resourcesPath = new HashMap();
		for (Iterator i = inFiles.iterator(); i.hasNext(); ) {
			Path f = (Path) i.next();
			if (! "class".equals(f.getFileExtension())) {
				String key = f.removeFirstSegments(path.segmentCount()).setDevice(null).toOSString();
				this.resourcesPath.put(key, f.toFile());
			}
		}
	}
	
	public Set getAspectPath() {
		return Collections.singleton(aspectPath);
	}

	public Set getInpath() {
		return inPath;
	}

	public Map getJavaOptionsMap() {
		return Collections.EMPTY_MAP;
	}

	public String getNonStandardOptions() {
		return "-showWeaveInfo -verbose";
	}

	public String getOutJar() {
		return null;
	}

	public IOutputLocationManager getOutputLocationManager() {
		return outPath;
	}

	public List getProjectSourceFiles() {
		return Collections.EMPTY_LIST;
	}

	public Map getSourcePathResources() {
		return resourcesPath;
	}

	public String getClasspath() {
		StringBuffer sb = new StringBuffer();
		
		for (int i = 0; i < classpath.length; i++) {
			sb.append(classpath[i]);
			if (i < classpath.length - 1)
				sb.append(";");
		}
		
		return sb.toString();
	}
	
}
