package pl.poznan.put.qjunit.ajcompiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.aspectj.ajde.core.IBuildMessageHandler;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessage.Kind;

public class BuildMessageHandler implements IBuildMessageHandler {

	private Set ignored = new HashSet();
	private List messages = new ArrayList();
	private boolean hasErrors;
	
	public void dontIgnore(Kind kind) {
		ignored.remove(kind);
	}

	public boolean handleMessage(IMessage message) throws AbortException {
		messages.add(message);
		
		if (! message.getKind().isSameOrLessThan(IMessage.WARNING))
			hasErrors = true;
		
		return true;
	}

	public void ignore(Kind kind) {
		ignored.add(kind);
	}

	public boolean isIgnoring(Kind kind) {
		return ignored.contains(kind);
	}
	
	public IMessage[] getMessages() {
		return (IMessage[]) messages.toArray(new IMessage[messages.size()]);
	}

	public boolean hasErrors() {
		return hasErrors;
	}

}
