package pl.poznan.put.qjunit;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import pl.poznan.put.qjunit.model.MutationModel;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "pl.poznan.put.qjunit";

	// The shared instance
	private static Activator plugin;
	
	private MutationModel mutationModel;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		
		mutationModel = new MutationModel();
		mutationModel.start();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
		mutationModel.stop();
		
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	public static void log(Throwable e) {
		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, 0, e.getMessage(), e);
		Activator activator = getDefault();
		if (activator != null) {
			getDefault().getLog().log(status);
		} else {
			e.printStackTrace();
		}
	}
	
	public static void log(String message, Throwable e) {
		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, 0, message, e);
		Activator activator = getDefault();
		if (activator != null) {
			getDefault().getLog().log(status);
		} else {
			System.out.println(message); // for tests and non-OSGi
			e.printStackTrace();
		}
	}
	
	public static MutationModel getMutationModel() {
		return getDefault().mutationModel;
	}

	protected void initializeImageRegistry(ImageRegistry reg) {
		reg.put(SharedImages.IMG_TEST_ERR, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_TEST_ERR));
		reg.put(SharedImages.IMG_TEST_FAIL, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_TEST_FAIL));
		reg.put(SharedImages.IMG_TEST_OK, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_TEST_OK));
		reg.put(SharedImages.IMG_SUITE_ERR, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_SUITE_ERR));
		reg.put(SharedImages.IMG_SUITE_FAIL, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_SUITE_FAIL));
		reg.put(SharedImages.IMG_SUITE_OK, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_SUITE_OK));
		reg.put(SharedImages.IMG_MUTATION_FAIL, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_MUTATION_FAIL));
		reg.put(SharedImages.IMG_MUTATION_OK, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_MUTATION_OK));
		reg.put(SharedImages.IMG_CLASS, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_CLASS));
		reg.put(SharedImages.IMG_FIELD, imageDescriptorFromPlugin(PLUGIN_ID, SharedImages.IMG_FIELD));
	}
	
	
}
