package pl.poznan.put.qjunit.runtime;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;

import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.RemoteTestRunner;
import org.eclipse.jdt.internal.junit.runner.TestExecution;

import pl.poznan.put.qjunit.response.DefaultDecoratedResponseProviderFactory;
import pl.poznan.put.qjunit.runtime.interceptor.InterceptorUtil;

public class QRemoteTestRunner extends RemoteTestRunner {
	
	private class MutationMessageSender implements MessageSender {

		public void flush() {
			fWriter.flush();
		}

		public void sendMessage(String msg) {
			if (fWriter != null)
				fWriter.println(msg);
		}
		
	}
	
	/**
	 * The client socket.
	 */
	private Socket fClientSocket;
	/**
	 * Print writer for sending messages
	 */
	private PrintWriter fWriter;
	
	private int fPort = -1;
	
	private String fHost = "";
	
	/**
	 * Is the debug mode enabled?
	 */
	private boolean fDebugMode= false;	
	
	private boolean fConsoleMode = false;
	
	public static void main(String[] args) {
		try {
			QRemoteTestRunner testRunServer= new QRemoteTestRunner();
			testRunServer.mutationsInit(args);
			testRunServer.init(args);
			testRunServer.run();
		} catch (Throwable e) {
			e.printStackTrace(); // don't allow System.exit(0) to swallow exceptions
		} finally {
			// fix for 14434
			System.exit(0);
		}
	}
	
	protected void mutationsInit(String[] args) {
		for(int i= 0; i < args.length; i++) {
			if(args[i].toLowerCase().equals("-mutation.port")) { //$NON-NLS-1$
				fPort= Integer.parseInt(args[i+1]);
				i++;
			} else if(args[i].toLowerCase().equals("-host")) { //$NON-NLS-1$
				fHost= args[i+1];
				i++;
			}  else if(args[i].toLowerCase().equals("-debugging") || args[i].toLowerCase().equals("-debug")){ //$NON-NLS-1$ //$NON-NLS-2$
			    fDebugMode= true;
			} else if (args[i].toLowerCase().equals("-junitconsole")) { //$NON-NLS-1$
			    fConsoleMode  = true;
			}
		}

		if (fPort == -1)
			throw new IllegalArgumentException("Missing argument -mutation.port"); //$NON-NLS-1$
		
		InterceptorUtil.INSTANCE.setResponseProviderFactory(new DefaultDecoratedResponseProviderFactory());
	}
	
	/**
	 * Connect to the remote test listener.
	 */
	protected boolean connect() {
		if (!super.connect())
			return false;
		
		if (fConsoleMode) {
			fClientSocket = null;
			fWriter = new PrintWriter(System.out);
			return true;
		}
		if (fDebugMode)
			System.out.println("RemoteTestRunner: trying to connect" + fHost + ":" + fPort); //$NON-NLS-1$ //$NON-NLS-2$
		Exception exception= null;
		for (int i= 1; i < 20; i++) {
			try{
				fClientSocket= new Socket(fHost, fPort);
				try {
				    fWriter= new PrintWriter(new BufferedWriter(new OutputStreamWriter(fClientSocket.getOutputStream(), "UTF-8")), false/*true*/); //$NON-NLS-1$
	            } catch (UnsupportedEncodingException e1) {
	                fWriter= new PrintWriter(new BufferedWriter(new OutputStreamWriter(fClientSocket.getOutputStream())), false/*true*/);
	            }
				return true;
			} catch(IOException e){
				exception= e;
			}
			try {
				Thread.sleep(2000);
			} catch(InterruptedException e) {
			}
		}
		runFailed("Error connecting to mutation port "+fHost+":"+fPort, exception); //$NON-NLS-1$
		return false;
	}
	
	public void runTests(String[] testClassNames, String testName, TestExecution execution) {
		MutationTestExecution wrapper = new MutationTestExecution(execution, new MutationMessageSender());
		super.runTests(testClassNames, testName, wrapper);
	}
	
}
