package pl.poznan.put.qjunit.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ObjectSerializer {
	
	public static final int MAX_DEPTH = 3;
	
	public static String serialize(Object object) {
		
		StringBuffer sb = new StringBuffer();
		
		try {
			_serialize(object, sb, 0);
		} catch (RuntimeException e) {
			System.out.println(e.getClass().getName()+": "+object.getClass().getName());
			return "11 UNAVAILABLE";
		}
		
		return sb.toString();
	}
	
	public static String escape(String string) {
		StringBuffer s = new StringBuffer(string);
		for (int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			if (c == '\n' || c == '\r' || c == ';')
				s.setCharAt(i, '#');
		}
		
		return s.toString();
	}
	
	protected static void _serialize(Object object, StringBuffer sb, int depth) {
		depth++;
		
		if (object == null) {
			sb.append("4 null");
			return;
		}
		
		String clazz = object.getClass().getName();
		if (clazz.startsWith("java.lang")) {
			String value = escape(object.toString());
			sb.append(value.length()).append(" ").append(value);
			return;
		}
		
		if (depth > MAX_DEPTH) {
			String value = escape(object.getClass().getName());
			sb.append(value.length()).append(" ").append(value);
			return;
		}
		
		if (object.getClass().isArray()) {
			serializeArray(object, sb, depth);
			return;
		}
		
		serializeObjectFields(object, sb, depth);
		return;
	}
	
	protected static void serializeArray(Object array, StringBuffer sb, int depth) {
		if (array instanceof boolean[]) {
			serialize((boolean[]) array, sb);
			return;
		}
		
		if (array instanceof byte[]) {
			serialize((byte[]) array, sb);
			return;
		}
		
		if (array instanceof char[]) {
			serialize((char[]) array, sb);
			return;
		}
		
		if (array instanceof long[]) {
			serialize((long[]) array, sb);
			return;
		}
		
		if (array instanceof short[]) {
			serialize((short[]) array, sb);
			return;
		}
		
		if (array instanceof int[]) {
			serialize((int[]) array, sb);
			return;
		}
		
		if (array instanceof float[]) {
			serialize((float[]) array, sb);
			return;
		}
		
		if (array instanceof double[]) {
			serialize((double[]) array, sb);
			return;
		}
		
		if (array instanceof int[]) {
			serialize((int[]) array, sb);
			return;
		}
		
		if (array instanceof Object[]) {
			serialize((Object[]) array, sb, depth);
			return;
		}
	}
	
	protected static void serializeObjectFields(Object object, StringBuffer sb, int depth) {
		Field[] fields = object.getClass().getDeclaredFields();
		
		sb.append(object.getClass().getName());
		
		List nonFinal = new ArrayList();
		
		for (int i = 0; i < fields.length; i++) {
			Field f = fields[i];
			f.setAccessible(true);
			
			int m = f.getModifiers();
			if (! Modifier.isFinal(m)) {
				nonFinal.add(f);
			}
		}
		
		sb.append(" ").append(nonFinal.size());
		
		for (Iterator i = nonFinal.iterator(); i.hasNext(); ) {
			Field f = (Field) i.next();

			sb.append(" ").append(f.getName()).append(" ");
			
			try {
				 _serialize(f.get(object), sb, depth);
			} catch (IllegalArgumentException e) {
				sb.append("IllegalArgumentException");
			} catch (IllegalAccessException e) {
				sb.append("IllegalAccessException");
			}
		}
	}
	
	public static String serialize(boolean boolean1) {
		String value = Boolean.toString(boolean1);
		return value.length() + " " + value;
	}

	public static String serialize(byte byte1) {
		String value = Byte.toString(byte1);
		return value.length() + " " + value;
	}

	public static String serialize(char char1) {
		String value = Character.toString(char1);
		return value.length() + " " + value;
	}

	public static String serialize(long long1) {
		String value = Long.toString(long1);
		return value.length() + " " + value;
	}
	
	public static String serialize(short short1) {
		String value = Short.toString(short1);
		return value.length() + " " + value;
	}

	public static String serialize(int int1) {
		String value = Integer.toString(int1);
		return value.length() + " " + value;
	}

	public static String serialize(float float1) {
		String value = Float.toString(float1);
		return value.length() + " " + value;
	}

	public static String serialize(double double1) {
		String value = Double.toString(double1);
		return value.length() + " " + value;
	}
	
	protected static void serialize(boolean[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(byte[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(char[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(long[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}
	
	protected static void serialize(short[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(int[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(float[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}

	protected static void serialize(double[] array, StringBuffer sb) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[").append(array[0]);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ").append(array[i]);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}
	
	protected static void serialize(Object[] array, StringBuffer sb, int depth) {
		if (array == null) {
			sb.append("4 null");
			return;
		}
		
		if (array.length == 0) {
			sb.append("2 []");
			return;
		}
		
		StringBuffer value = new StringBuffer();
		value.append("[");
		_serialize(array[0], value, depth);
		
		for (int i = 1; i < array.length; i++) {
			value.append(", ");
			_serialize(array[i], value, depth);
		}
		
		value.append("]");
		
		sb.append(value.length()).append(" ").append(value);
	}
}
