package pl.poznan.put.qjunit.runtime;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import pl.poznan.put.qjunit.response.DecoratedResponseProvider;
import pl.poznan.put.qjunit.runtime.interceptor.InterceptorUtil;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProvider;

public class NextGenTestResult extends TestResult {
	
	/**
	 * Runs a test case and then evaluates mutations
	 */
	protected void run(final TestCase test) {
		InterceptorUtil.INSTANCE.learn();
		
		// initial run
		super.run(test);
		
		InterceptorUtil.INSTANCE.mock();
		startMutations(test);
		
		// subsequently runs for all available alternative responses - change one response at a time
		ResponseProvider[] rps = InterceptorUtil.INSTANCE.getResponseProviders();
		List infos = new ArrayList(rps.length);
		
		for (int i = 0; i < rps.length; i++) {
			DecoratedResponseProvider rp = (DecoratedResponseProvider)rps[i];
			
			if (rp.hasNextResponse()) { // if there's at least one response injection
				MutationInfo info = createInfo(rp);
				InterceptorUtil.INSTANCE.setCurrentProvider(rp);
				
				while (rp.hasNextResponse()) {
					try {
						rp.next();
						
						info.addGenerator(rp.getName());
						info.addGenerated(rp);
						super.run(test);
					} catch (Throwable e) {
						// ignore if failed to generate response
						//System.out.println(rp.getName()+".next() failed with "+e.getClass().getName()+": "+e.getMessage());
					}
				}
				
				try {
					rp.dispose();
				} catch (Throwable e) {
					// ignore if failed to generate response
					//e.printStackTrace();
				}
				
				infos.add(info);
			}
		}
		
		
		endMutations(test, (MutationInfo[])infos.toArray(new MutationInfo[infos.size()]));
	}

	protected MutationInfo createInfo(DecoratedResponseProvider rp) {
		MutationInfo info = new MutationInfo();
		info.setResponseType(rp.getType());
		InterceptorUtil.JoinPointInfo location = InterceptorUtil.INSTANCE.getJoinPointInfo(rp);
		info.setFileName(location.fileName);
		info.setLine(location.line);
		info.setSignature(location.signature);
		info.setLearned(rp.getLearnedResponses());
		
		return info;
	}

	protected void startMutations(Test test) {
		for (Enumeration e= fListeners.elements(); e.hasMoreElements(); ) {
			Object listener = e.nextElement();
			if (listener instanceof MutationTestListener) {
				((MutationTestListener)listener).startMutations(test);
			}
		}
	}
	
	protected void endMutations(Test test, MutationInfo[] info) {
		for (Enumeration e= fListeners.elements(); e.hasMoreElements(); ) {
			Object listener = e.nextElement();
			if (listener instanceof MutationTestListener) {
				((MutationTestListener)listener).endMutations(test, info);
			}
		}
	}
}
