package pl.poznan.put.qjunit.runtime;

import java.util.ArrayList;
import java.util.List;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;

import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.ITestIdentifier;
import org.eclipse.jdt.internal.junit.runner.MessageIds;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.TestExecution;

/**
 * Carries additional information about mutations results
 *
 */
public class MutationTestListener implements TestListener {

	private List results = new ArrayList();
	private String result = null;
	
	private List messages = new ArrayList();
	private String message = null;
	
	private boolean fMutationMode = false;
	
	private MessageSender mutationSender;
	
	private final IListensToTestExecutions fNotified;

	private final IClassifiesThrowables fClassifier;
	
	public MutationTestListener(TestExecution execution) {
		fNotified= execution.getListener();
		fClassifier= execution.getClassifier();
		
		if (execution instanceof MutationTestExecution) {
			mutationSender = ((MutationTestExecution)execution).getMutationSender();
		}
	}

	public void addError(Test test, Throwable t) {
		if (fMutationMode) {
			result = "error";
			message = t.getMessage();
			if (message == null || message.equals(""))
				message = t.getClass().getName();
			
			//System.out.println(test+" mutation error "+t.getClass().getName()+": "+t.getMessage());
		} else {
			newReference(test).sendFailure(t, fClassifier, MessageIds.TEST_ERROR, fNotified);
		}
	}

	public void addFailure(Test test, AssertionFailedError t) {
		if (fMutationMode) {
			result = "failure";
			message = t.getMessage();
			if (message == null || message.equals(""))
				message = t.getClass().getName();
			
			//System.out.println(test+" mutation failure "+t);
		} else {
			newReference(test).sendFailure(t, fClassifier, MessageIds.TEST_FAILED, fNotified);
		}
	}

	public void endTest(Test test) {
		if (fMutationMode) {
			
			result = (result == null) ? "ok" : result;
			message = (message == null) ? " " : ObjectSerializer.escape(message); // FIXME there's problem with processing empty tokens by StringTokenizer - return " " instead of ""
			
			results.add(result);
			messages.add(message);
			
			result = null;
			message = null;
		} else {
			fNotified.notifyTestEnded(id(test));
		}
	}

	public void startTest(Test test) {
		if (fMutationMode) {
		} else {
			fNotified.notifyTestStarted(id(test));
		}
	}

	public void startMutations(Test test) {
		fMutationMode = true;
	}
	
	public void endMutations(Test test, MutationInfo[] infos) {
		fMutationMode = false;
		
		TestCase tc = (TestCase) test;
		
		if (mutationSender == null) {
			return;
		}
		
		for (int i = 0; i < infos.length; i++) {
			MutationInfo info = infos[i];
			String[] infoResults = new String[info.getGenerated().length];
			String[] infoMessages = new String[info.getGenerated().length];
			long[] infoTimings = new long[info.getGenerated().length];
			for (int j = 0; j < infoResults.length; j++) {
				infoResults[j] = (String) results.remove(0);
				infoMessages[j] = (String) messages.remove(0);
				infoTimings[j] = 0;
			}
			info.setResults(infoResults);
			info.setMessages(infoMessages);
			info.setTiming(infoTimings);
			
			String message = tc.getClass().getName()+";"+tc.getName()+";"+info.toString();
			mutationSender.sendMessage(message);
			mutationSender.flush();
		}
	}

	private ITestIdentifier id(Test test) {
		return newReference(test).getIdentifier();
	}

	private QJUnitTestReference newReference(Test test) {
		return new QJUnitTestReference(test);
	}
}
