package pl.poznan.put.qjunit.runtime;

import org.eclipse.jdt.internal.junit.runner.IClassifiesThrowables;
import org.eclipse.jdt.internal.junit.runner.IListensToTestExecutions;
import org.eclipse.jdt.internal.junit.runner.IStopListener;
import org.eclipse.jdt.internal.junit.runner.ITestReference;
import org.eclipse.jdt.internal.junit.runner.MessageSender;
import org.eclipse.jdt.internal.junit.runner.TestExecution;

/**
 * Carries additional information about mutations results
 *
 */
public class MutationTestExecution extends TestExecution {

	private TestExecution execution;
	private MessageSender mutationSender;
	
	public MutationTestExecution(TestExecution execution, MessageSender mutationSender) {
		super(null, null);
		this.execution = execution;
		this.mutationSender = mutationSender;
	}

	public void addStopListener(IStopListener listener) {
		execution.addStopListener(listener);
	}

	public IClassifiesThrowables getClassifier() {
		return execution.getClassifier();
	}

	public IListensToTestExecutions getListener() {
		return execution.getListener();
	}

	public void run(ITestReference[] suites) {
		for (int i = 0; i < suites.length; i++) {
			if (execution.shouldStop())
				return;
			suites[i].run(this);
		}
	}

	public boolean shouldStop() {
		return execution.shouldStop();
	}

	public void stop() {
		execution.stop();
	}
	
	public MessageSender getMutationSender() {
		return mutationSender;
	}

}
