package pl.poznan.put.qjunit.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import pl.poznan.put.qjunit.runtime.interceptor.ResponseProvider;

public class MutationInfo {

	private int response_type;
	
	private String[] learned;
	
	private List generated = new ArrayList();
	
	private List generators = new ArrayList();
	
	private String[] results;
	
	private String[] resultMessages;
	
	private long[] timing;
	
	private String fileName;
	
	private int line;

	private String signature;

	public Object[] getLearned() {
		return learned;
	}

	public void setLearned(Object[] learned) {
		this.learned = new String[learned.length];
		for (int i = 0; i < learned.length; i++) {
			this.learned[i] = ObjectSerializer.serialize(learned[i]);
		}
	}

	public Object[] getGenerated() {
		return generated.toArray();
	}

	public Object[] getGenerators() {
		return generators.toArray();
	}
	
	public void addGenerated(ResponseProvider rp) {
		String string = null;
		
		switch (response_type) {
		case ResponseProvider.TYPE_OBJECT:
			string = ObjectSerializer.serialize(rp.getObject());
			break;
		case ResponseProvider.TYPE_BOOLEAN:
			string = ObjectSerializer.serialize(rp.getBoolean());
			break;
		case ResponseProvider.TYPE_BYTE:
			string = ObjectSerializer.serialize(rp.getByte());
			break;
		case ResponseProvider.TYPE_CHAR:
			string = ObjectSerializer.serialize(rp.getChar());
			break;
		case ResponseProvider.TYPE_DOUBLE:
			string = ObjectSerializer.serialize(rp.getDouble());
			break;
		case ResponseProvider.TYPE_FLOAT:
			string = ObjectSerializer.serialize(rp.getFloat());
			break;
		case ResponseProvider.TYPE_INT:
			string = ObjectSerializer.serialize(rp.getInt());
			break;
		case ResponseProvider.TYPE_LONG:
			string = ObjectSerializer.serialize(rp.getLong());
			break;
		case ResponseProvider.TYPE_SHORT:
			string = ObjectSerializer.serialize(rp.getShort());
			break;
		}
		
		
		generated.add(string);
	}

	public String[] getResults() {
		return results;
	}

	public void setResults(String[] results) {
		this.results = results;
	}

	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public int getLine() {
		return line;
	}

	public void setLine(int line) {
		this.line = line;
	}
	
	public void setResponseType(int type) {
		response_type = type;
	}
	
	public int getResponseType() {
		return response_type;
	}

	public void setTiming(long[] timing) {
		this.timing = timing;
	}
	

	public void setSignature(String signature) {
		this.signature = signature;
		
	}
	
	public String getSignature() {
		return signature;
	}

	public void addGenerator(String name) {
		generators.add(name);
	}
	
	/**
	 * see MutationSession.receiveMessage(String);
	 * Serializes to:
	 * "RESPONSE_TYPE;FILE_NAME;LINE;DECLARINGTYPE;NAME;LEARNED;GENERATORS;GENERATED;RESULTS;MESSAGES;TIMING" 
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(response_type).append(";");
		sb.append(fileName).append(";");
		sb.append(line).append(";");
		sb.append(signature).append(";");
		
		// send learned answers
		sb.append(learned.length).append(";");
		for (int i = 0; i < learned.length; i++) {
			sb.append(learned[i]).append(";");
		}
		
		// send generators names
		sb.append(generators.size()).append(";");
		for (Iterator i = generators.iterator(); i.hasNext(); ) {
			sb.append(i.next()).append(";");
		}
		
		// send generated answers
		sb.append(generated.size()).append(";");
		for (Iterator i = generated.iterator(); i.hasNext(); ) {
			sb.append(i.next()).append(";");
		}
		
		// send results
		sb.append(results.length).append(";");
		for (int i = 0; i < results.length; i++) {
			sb.append(results[i]).append(";");
		}
		
		// send result messages
		sb.append(resultMessages.length).append(";");
		for (int i = 0; i < resultMessages.length; i++) {
			sb.append(resultMessages[i]).append(";");
		}
		
		// send timing
		sb.append(timing.length).append(";");
		for (int i = 0; i < timing.length; i++) {
			sb.append(timing[i]).append(";");
		}
		
		return sb.toString();
	}

	/**
	 * Sets results messages. For "ok" result it's empty string, for error or failure it's exception message.
	 * @param infoMessages
	 */
	public void setMessages(String[] infoMessages) {
		resultMessages = infoMessages;
	}
	
}
