package pl.poznan.put.qjunit.runtime;

import java.text.DecimalFormat;
import java.util.Hashtable;

import pl.poznan.put.qjunit.model.ObjectDeserializer;

import junit.framework.TestCase;

public class ObjectSerializerTest extends TestCase {

	public void testSerializeObject() {
		A a = new A();
		System.out.println(ObjectSerializer.serialize(a));
	}
	
	public void testStaticFinalField() {
		B b = new B();
		System.out.println(ObjectSerializer.serialize(b));
	}
	
	public void testClass() {
		Class clazz = getClass();
		System.out.println(ObjectSerializer.serialize(clazz));
	}
	
	public void testStrings() {
		StringsClass a = new StringsClass();
		System.out.println(ObjectSerializer.serialize(a));
	}
	
	public void testObjectArray() {
		Object[] a = new Object[] { "a", "b", "c" };
		System.out.println(ObjectSerializer.serialize(a));
	}
	
	public void testHashMap() {
		Hashtable map = new Hashtable(3);
		map.put("key1", "value1");
		map.put("key2", "value2");
		map.put("key3", "value3");
		System.out.println(ObjectSerializer.serialize(map));
	}
	
	public void testDecimalFormat() {
		DecimalFormat df = new DecimalFormat();
		System.out.println(ObjectSerializer.serialize(df));
	}
	
	public void testPrimitiveInt() {
		System.out.println(ObjectSerializer.serialize(4));
	}
	
	public void testPrimitiveInteger() {
		System.out.println(ObjectSerializer.serialize(new Integer(4)));
	}
	
	public void testArrayOfObjectAtMaxDepth() {
		Object[] o = new Object[] { new Object[] { new Object[] { new Object[] { new Object[] { "a" }}}}};
		System.out.println(ObjectSerializer.serialize(o));
	}
}
