package pl.poznan.put.qjunit.response.providers.operators;

import junit.framework.TestCase;

public class ZeroAllPrimitiveFieldsTest extends TestCase {

	private static class Primitives {
		public int i = 10;
		public char c = 'z';
		private byte b = (byte)20;
		private float f = 1.0f;
		protected boolean bo = true;
	}
	
	private ZeroAllPrimitiveFields f;
	
	protected void setUp() {
		f = new ZeroAllPrimitiveFields();
	}
	
	public void testPrimitiveIntFieldReset() {
		Primitives ic = new Primitives();
		
		assertTrue(f.canMutate(ic));
		
		Primitives mutation = (Primitives) f.getMutation(ic);
		
		assertEquals(0, mutation.i);
		assertEquals((char)0, mutation.c);
		assertEquals((byte)0, mutation.b);
		assertEquals(0.0f, mutation.f);
		assertEquals(false, mutation.bo);
	}
	
	public void testInPlace() {
		Primitives ic = new Primitives();
		Primitives mutation = (Primitives) f.getMutation(ic);
		
		assertSame(ic, mutation);
	}
	
	public void testRestore() {
		Primitives ic = new Primitives();
		Primitives mutation = (Primitives) f.getMutation(ic);
		f.restore(mutation);
		
		assertEquals(10, mutation.i);
		assertEquals('z', mutation.c);
		assertEquals((byte)20, mutation.b);
		assertEquals(1.0f, mutation.f);
		assertEquals(true, mutation.bo);
	}
}
