package pl.poznan.put.qjunit.response.providers.operators;

import junit.framework.TestCase;

public class OperatorsUtilsTest extends TestCase {

	private static class PrivateA {
		public void someMethod() {
			// empty
		}
	}
	
	public static class PublicA {
		public void someMethod() {
			// empty
		}
	}
	
	public static class WithConstructor {
		public WithConstructor(int a) {
			// empty non-default constructor
		}
	}
	
	public void testNewInstancePrivateA() {
		Object o = OperatorsUtils.newInstance(PrivateA.class);
		assertNull(o); // fail to create instance of private class
	}
	
	public void testNewInstancePublicA() {
		Object o = OperatorsUtils.newInstance(PublicA.class);
		assertNotNull(o);
	}
	
	public void testCreateProxy1() {
		Object o = new PublicA();
		
		Object proxy = OperatorsUtils.createProxy(o.getClass(), o);
		
		assertNotNull(proxy);
		assertTrue(o.getClass().isAssignableFrom(proxy.getClass()));
	}
	
	public void testCreateProxy2() {
		Object o = new PrivateA();
		
		Object proxy = OperatorsUtils.createProxy(o.getClass(), o);
		
		assertNotNull(proxy);
		assertTrue(o.getClass().isAssignableFrom(proxy.getClass()));
	}
	
	public void testCreateProxy3() {
		Object o = new WithConstructor(0);
		
		Object proxy = OperatorsUtils.createProxy(o.getClass(), o);
		
		assertNotNull(proxy);
		assertTrue(o.getClass().isAssignableFrom(proxy.getClass()));
	}

}
