package pl.poznan.put.qjunit.response.providers.operators;

import junit.framework.TestCase;

public class NullAllMethodsTest extends TestCase {

	public interface Interf1 {
		public Object getObject();
		public int getInt();
	}
	
	public static class ClassA implements Interf1 {

		public int getInt() {
			return 7;
		}

		public Object getObject() {
			return "a string";
		}
	}
	
	public void testClassA() {
		NullAllMethodsProxy f = new NullAllMethodsProxy(Interf1.class);
		Object o = new ClassA();
		
		assertTrue(f.canMutate(o));
		
		Interf1 mutation = (Interf1) f.getMutation(o);
		
		assertTrue(mutation instanceof Interf1);
		assertNull(mutation.getObject());
		assertEquals(0, mutation.getInt());
	}
}
