package pl.poznan.put.qjunit.response.providers.operators;

import junit.framework.TestCase;

public class NullAllFieldsTest extends TestCase {

	public static class A {
		public String fieldA;
		private String fieldB;
		protected String fieldC;
		
		public A(String a, String b, String c) {
			fieldA = a;
			fieldB = b;
			fieldC = c;
		}
	}
	
	protected NullAllFields f;
	
	protected void setUp() {
		f = new NullAllFields();
	}
	
	public void testRestore() {
		A a = new A("a", "b", "c");
		
		assertTrue(f.canMutate(a));
		A mutation = (A) f.getMutation(a);
		
		assertSame(a, mutation);
		
		assertNull(a.fieldA);
		assertNull(a.fieldB);
		assertNull(a.fieldC);
		
		f.restore(mutation);
		
		assertEquals("a", a.fieldA);
		assertEquals("b", a.fieldB);
		assertEquals("c", a.fieldC);
	}
}
