package pl.poznan.put.qjunit.model;

import java.text.DecimalFormat;

import junit.framework.TestCase;
import pl.poznan.put.qjunit.runtime.A;
import pl.poznan.put.qjunit.runtime.B;
import pl.poznan.put.qjunit.runtime.ObjectSerializer;

public class ObjectDeserializerTest extends TestCase {

	ObjectDeserializer deserializer;
	
	protected void setUp() {
		deserializer = new ObjectDeserializer();
	}
	
	public void testB() {
		String value = ObjectSerializer.serialize(new B());
		ComplexResponse resp = (ComplexResponse) deserializer.create("learned", value, ComplexResponse.TYPE_OBJECT);
		validateComplexResponse(resp, "learned", "pl.poznan.put.qjunit.runtime.B", null);
		
		ComplexResponse[] children = resp.getChildren();
		assertNotNull(children);
		assertEquals(1, children.length);
		
		validateComplexResponse(children[0], "a", "java.lang.Object", "3");
		
	}
	
	public void testA() {
		String value = ObjectSerializer.serialize(new A());
		ComplexResponse resp = (ComplexResponse) deserializer.create("learned", value, ComplexResponse.TYPE_OBJECT);
		
		validateComplexResponse(resp, "learned", "pl.poznan.put.qjunit.runtime.A", null);
		
		ComplexResponse[] children = resp.getChildren();
		assertNotNull(children);
		assertEquals(4, children.length);
		
		validateComplexResponse(children[0], "a", "java.lang.Object", "1");
		validateComplexResponse(children[1], "b", "java.lang.Object", "10");
		validateComplexResponse(children[2], "internalA", "pl.poznan.put.qjunit.runtime.A", null);
		validateComplexResponse(children[3], "array", "java.lang.Object", "[a, b, c]");
		
	}
	
	public void testEmptyClass() {
		String value = "org.apache.commons.math.geometry.Vector3D 0";
		ComplexResponse resp = (ComplexResponse) deserializer.create("learned", value, ComplexResponse.TYPE_OBJECT);
		
		validateComplexResponse(resp, "learned", "org.apache.commons.math.geometry.Vector3D", null);
		assertNull(resp.getChildren());
	}
	
	public void testClass() {
		String value = ObjectSerializer.serialize(this.getClass());
		ComplexResponse resp = (ComplexResponse) deserializer.create("learned", value, ComplexResponse.TYPE_OBJECT);
		
		validateComplexResponse(resp, "learned", "java.lang.Object", "class pl.poznan.put.qjunit.model.ObjectDeserializerTest");
	}
	
	public void testDecimalFormat() {
		String value = ObjectSerializer.serialize(new DecimalFormat());
		ComplexResponse resp = (ComplexResponse) deserializer.create("learned", value, ComplexResponse.TYPE_OBJECT);
	}
	
	public void testReadValue() {
		String response = deserializer.readValue("3 abc");
		assertEquals("abc", response);
	}
	
	public void testPrimitiveInt() {
		Object o = deserializer.create("learned", "2 -5", ComplexResponse.TYPE_INT);
		assertTrue(o instanceof Integer);
		assertEquals(-5, ((Integer)o).intValue());
	}
	
	public void testPrimitiveChar() {
		Object o = deserializer.create("learned", "1 c", ComplexResponse.TYPE_CHAR);
		assertTrue(o instanceof Character);
		assertEquals('c', ((Character)o).charValue());
	}
	
	protected static void validateComplexResponse(ComplexResponse resp, String name, String type, Object value) {
		assertEquals(name, resp.getName());
		assertEquals(type, resp.getType());
		assertEquals(value, resp.getValue());
	}

}
