package pl.poznan.put.qjunit.runtime.interceptor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.lang.reflect.SourceLocation;

public class InterceptorUtil {

	public static InterceptorUtil INSTANCE = new InterceptorUtil();
	
	public static class JoinPointInfo {
		public String fileName;
		public int line;
		public String signature;
	}
	
	private boolean isLearning;
	
	private Map joinPoints = new HashMap();
	
	private ResponseProvider current = null;
	
	private ResponseProviderFactory factory;
	
	private InterceptorUtil() {
		// empty
	}
	
	public void setResponseProviderFactory(ResponseProviderFactory factory) {
		this.factory = factory;
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, boolean origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createBooleanResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, char origResponse) {
		joinPoints.put(joinPoint, factory.createCharResponseProvider(joinPoint));
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createFloatResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, byte origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createByteResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, int origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createIntResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, float origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createFloatResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, double origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createDoubleResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, long origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createLongResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, short origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createShortResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}
	
	public void learn(JoinPoint.StaticPart joinPoint, Object origResponse) {
		ResponseProvider rp = (ResponseProvider) joinPoints.get(joinPoint);
		if (rp == null) {
			rp = factory.createObjectResponseProvider(joinPoint);
			joinPoints.put(joinPoint, rp);
		}
		
		rp.add(origResponse);
	}

	public JoinPointInfo getJoinPointInfo(ResponseProvider provider) {
		for (Iterator i = joinPoints.keySet().iterator(); i.hasNext(); ) {
			JoinPoint.StaticPart key = (JoinPoint.StaticPart)i.next();
			if (provider.equals(joinPoints.get(key))) {
				JoinPointInfo info = new JoinPointInfo();
				SourceLocation sourceLocation = key.getSourceLocation();
				
				info.fileName = sourceLocation.getFileName();
				info.line = sourceLocation.getLine();
				info.signature = ((MethodSignature)key.getSignature()).toString();
				return info;
			}
		}
		
		return null;
	}
	
	public ResponseProvider getResponses(JoinPoint.StaticPart staticPart) {
		return (ResponseProvider) joinPoints.get(staticPart);
	}
	
	public ResponseProvider[] getResponseProviders() {
		return (ResponseProvider[]) joinPoints.values().toArray(new ResponseProvider[joinPoints.values().size()]);
	}

	public void learn() {
		joinPoints.clear();
		isLearning = true;
	}
	
	public void mock() {
		isLearning = false;
	}
	
	public boolean isLearning() {
		return isLearning;
	}
	
	public void setCurrentProvider(ResponseProvider provider) {
		current = provider;
	}
	
	public boolean isCurrent(ResponseProvider provider) {
		//System.out.println("IsCurrent "+provider+"? ("+current+") "+(current==provider));
		return current == provider;
	}

}
