package pl.poznan.put.qjunit.runtime.interceptor;

public aspect Interceptor {

	pointcut systemCallBoolean() : this(junit.framework.TestCase) && withincode(* test*(..)) && call(boolean *(..));
	pointcut systemCallChar()    : this(junit.framework.TestCase) && withincode(* test*(..)) && call(char *(..));
	pointcut systemCallByte()    : this(junit.framework.TestCase) && withincode(* test*(..)) && call(byte *(..));
	pointcut systemCallInt()     : this(junit.framework.TestCase) && withincode(* test*(..)) && call(int *(..));
	pointcut systemCallFloat()   : this(junit.framework.TestCase) && withincode(* test*(..)) && call(float *(..));
	pointcut systemCallDouble()  : this(junit.framework.TestCase) && withincode(* test*(..)) && call(double *(..));
	pointcut systemCallShort()   : this(junit.framework.TestCase) && withincode(* test*(..)) && call(short *(..));
	pointcut systemCallLong()    : this(junit.framework.TestCase) && withincode(* test*(..)) && call(long *(..));
	pointcut systemCallObject()  : this(junit.framework.TestCase) && withincode(* test*(..)) && call(java.lang.Object+ *(..));
	
	// LESSON LEARNED weave only into test* methods, because other (e.g. suite(), setUp()) may damage tests execution. 
	
	boolean around(): systemCallBoolean() {
		boolean response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getBoolean();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	char around(): systemCallChar() {
		char response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getChar();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	byte around(): systemCallByte() {
		byte response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getByte();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	int around(): systemCallInt() {
		int response;
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getInt();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	float around(): systemCallFloat() {
		float response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getFloat();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	double around(): systemCallDouble() {
		double response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getDouble();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	short around(): systemCallShort() {
		short response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getShort();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	long around(): systemCallLong() {
		long response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getLong();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
	
	Object around(): systemCallObject() {
		Object response;
		
		if (InterceptorUtil.INSTANCE.isLearning()) {
			response = proceed();
			InterceptorUtil.INSTANCE.learn(thisJoinPointStaticPart, response);
		} else {
			ResponseProvider rp = InterceptorUtil.INSTANCE.getResponses(thisJoinPointStaticPart);
			if (InterceptorUtil.INSTANCE.isCurrent(rp)) {
				response = rp.getObject();
			} else {
				response = proceed();
			}
		}
		
		return response;
	}
}