package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * 
 *
 * Doesn't work for java.lang.* objects // XXX workaround for http://se.cs.put.poznan.pl/sebugs/show_bug.cgi?id=33
 */
public class ZeroAllPrimitiveFields implements ObjectMutationOperator {

	protected Map fieldsHistory = new HashMap();
	
	/**
	 * canMutate if object has at least one primitive non-zero field
	 */
	public boolean canMutate(Object o) {
		if (o == null)
			return false;
		
		Class clazz = o.getClass();
		
		if (clazz.getName().startsWith("java.lang"))
			return false;
		
		Field[] fields = clazz.getDeclaredFields();
		
		for (int i =0; i < fields.length; i++) {
			if (! fields[i].isAccessible())
				fields[i].setAccessible(true);
			
			Class type = fields[i].getType();
			
			try {
				if (type.isPrimitive() && (!isZero(fields[i], type, o))) {
					return true;
				}
			} catch (IllegalArgumentException e) {
				// empty
			} catch (IllegalAccessException e) {
				// empty
			}
		}
		
		return false;
	}

	public Object getMutation(Object o) {
		Class clazz = o.getClass();
		Field[] fields = clazz.getDeclaredFields();
		
		for (int i =0; i < fields.length; i++) {
			if (! fields[i].isAccessible())
				fields[i].setAccessible(true);
			
			Class type = fields[i].getType();
			if (type.isPrimitive()) {
				try {
					Object value = OperatorsUtils.getPrimitive(fields[i], type, o);
					fieldsHistory.put(fields[i], value);
					setZero(fields[i], type, o);
				} catch (IllegalAccessException e) {
					// empty
				}
			}
		}
		
		return o;
	}
	
	static protected boolean isZero(Field field, Class type, Object obj) throws IllegalArgumentException, IllegalAccessException {
		if (type.equals(Integer.TYPE)) {
			return field.getInt(obj) == 0;
		} else if (type.equals(Boolean.TYPE)) {
			return field.getBoolean(obj) == false;
		} else if (type.equals(Byte.TYPE)) {
			return field.getByte(obj) == (byte)0;
		} else if (type.equals(Character.TYPE)) {
			return field.getChar(obj) == (char)0;
		} else if (type.equals(Double.TYPE)) {
			return field.getDouble(obj) == 0;
		} else if (type.equals(Float.TYPE)) {
			return field.getFloat(obj) == 0;
		} else if (type.equals(Long.TYPE)) {
			return field.getLong(obj) == 0;
		} else if (type.equals(Short.TYPE)) {
			return field.getShort(obj) == (short)0;
		}
		
		return false;
	}
	
	static protected void setZero(Field field, Class type, Object obj) throws IllegalArgumentException, IllegalAccessException {
		if (type.equals(Integer.TYPE)) {
			field.setInt(obj, 0);
		} else if (type.equals(Boolean.TYPE)) {
			field.setBoolean(obj, false);
		} else if (type.equals(Byte.TYPE)) {
			field.setByte(obj, (byte)0);
		} else if (type.equals(Character.TYPE)) {
			field.setChar(obj, (char)0);
		} else if (type.equals(Double.TYPE)) {
			field.setDouble(obj, 0);
		} else if (type.equals(Float.TYPE)) {
			field.setFloat(obj, 0);
		} else if (type.equals(Long.TYPE)) {
			field.setLong(obj, 0);
		} else if (type.equals(Short.TYPE)) {
			field.setShort(obj, (short)0);
		}
	}
	
	public void restore(Object o) {
		for (Iterator i = fieldsHistory.entrySet().iterator(); i.hasNext(); ) {
			Map.Entry entry = (Map.Entry) i.next();
			
			Field field = (Field) entry.getKey();
			try {
				OperatorsUtils.setPrimitive(field, field.getType(), o, entry.getValue());
			} catch (IllegalArgumentException e) {
				// empty
			} catch (IllegalAccessException e) {
				// empty
			}
		}
	}
	
	public String getName() {
		return "ZAPF";
	}
}
