package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.Method;
import java.util.List;

public class RemoveListElement extends AbstractCollectionsOperator {

	private Object removedElement;
	
	public RemoveListElement(Method method) {
		super(method);
	}

	public boolean canMutate(Object o) {
		return super.canMutate(o) && (o != null) && (o instanceof List) && (!((List) o).isEmpty());
	}

	public Object getMutation(Object o) {
		removedElement = ((List) o).remove(0);
		return o;
	}

	public String getName() {
		return "RLE";
	}

	public void restore(Object o) {
		((List) o).add(0, removedElement);
	}

}
