package pl.poznan.put.qjunit.response.providers.operators;

import pl.poznan.put.qjunit.response.LearningAdapter;

public class ObjectMutationProvider extends LearningAdapter {

	private ObjectMutationOperator[] operators;
	private int current;
	private Object object;
	private int lastUsed = -1;
	
	public ObjectMutationProvider(ObjectMutationOperator[] operators) {
		this.operators = operators;
	}
	
	public int getType() {
		return TYPE_OBJECT;
	}
	
	public boolean hasNextResponse() {
		if ((learnedResponses.size()) == 0) {
			return false;
		}
		
		current = lastUsed + 1;
		
		while (current < operators.length) {
			boolean canMutate;
			
			try {
				canMutate = operators[current].canMutate(learnedResponses.get(0));
			} catch (Throwable e) {
				canMutate = false;
			}
			
			//System.out.println("canMutate "+operators[current].getName()+" "+canMutate);
			if (canMutate) {
				return true;
			} else {
				current++;
			}
		}
		
		return false;
	}

	public void next() {
		try {
			dispose();
			
			object = operators[current].getMutation(learnedResponses.get(0));
		} catch (Throwable t) {
		}
		
		lastUsed = current;
	}

	public Object getObject() {
		return object;
	}
	
	public void dispose() {
		if (lastUsed != -1) { // restore last mutated object
			operators[lastUsed].restore(object);
		}
	}
	
	public String getName() {
		if ((current >= 0) && (current <= operators.length)) {
			return operators[current].getName();
		}
		
		return "null";
	}
	
}
