package pl.poznan.put.qjunit.response.providers.operators;


public class ObjectInsteadOfNull implements ObjectMutationOperator {

	private Class type;
	
	public ObjectInsteadOfNull(Class type) {
		this.type = type;
	}

	public boolean canMutate(Object o) {
		return o == null && (OperatorsUtils.newInstance(type) != null);
	}
	
	public Object getMutation(Object o) {
		return OperatorsUtils.newInstance(type);
	}

	public void restore(Object o) {
		// empty - this operator returns new instances
	}
	
	public String getName() {
		return "OION";
	}
}
