package pl.poznan.put.qjunit.response.providers.operators;

/**
 * Returns null or 0/false for all method calls to the proxy
 *
 */
public class NullAllMethodsProxy extends AbstractProxyOperator {

	public NullAllMethodsProxy(Class type) {
		super(type);
	}

	public Object invoke(Object proxy, java.lang.reflect.Method method,
			Object[] args) throws Throwable {
		Class retType = method.getReturnType();
		
		if (retType.isPrimitive()) {
			if (retType.equals(Integer.TYPE)) {
				return new Integer(0);
			} else if (retType.equals(Boolean.TYPE)) {
				return Boolean.FALSE;
			} else if (retType.equals(Byte.TYPE)) {
				return new Byte((byte)0);
			} else if (retType.equals(Character.TYPE)) {
				return new Character((char)0);
			} else if (retType.equals(Double.TYPE)) {
				return new Double(0.0d);
			} else if (retType.equals(Float.TYPE)) {
				return new Float(0.0f);
			} else if (retType.equals(Long.TYPE)) {
				return new Long((long)0);
			} else if (retType.equals(Short.TYPE)) {
				return new Short((short)0);
			}
		}
		
		return null;
	}
	
	public String getName() {
		return "NAMP";
	}
}
