package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


/**
 * Operator sets all non-primitive fields of object to null.
 * It doesn't include inherited fields.
 * Doesn't work for java.lang.* objects // XXX workaround for http://se.cs.put.poznan.pl/sebugs/show_bug.cgi?id=33
 *
 */
public class NullAllFields implements ObjectMutationOperator {

	private Map fieldsHistory = new HashMap();
	
	public boolean canMutate(Object o) {
		if (o == null)
			return false;
		
		Class clazz = o.getClass();
		
		if (clazz.getName().startsWith("java.lang"))
			return false;
		
		Field[] fields = clazz.getDeclaredFields();
		
		for (int i =0; i < fields.length; i++) {
			if (! fields[i].isAccessible())
				fields[i].setAccessible(true);
			
			if (! fields[i].getType().isPrimitive()) {
				try {
					if (fields[i].get(o) != null) {
						return true;
					}
				} catch (IllegalArgumentException e) {
					// empty
				} catch (IllegalAccessException e) {
					// empty
				}
			}
		}
		
		return false;
	}
	
	public Object getMutation(Object o) {
		Class clazz = o.getClass();
		Field[] fields = clazz.getDeclaredFields();
		
		fieldsHistory.clear();
		
		for (int i =0; i < fields.length; i++) {
			if (! fields[i].isAccessible())
				fields[i].setAccessible(true);
			
			if (! fields[i].getType().isPrimitive()) {
				
				try {
					Object orig = fields[i].get(o);
					if (orig != null) {
						fieldsHistory.put(fields[i], orig);
						fields[i].set(o, null);
					}
				} catch (IllegalArgumentException e) {
					// empty
				} catch (IllegalAccessException e) {
					// empty
				}
			}
		}
		
		return o;
	}

	public void restore(Object o) {
		for (Iterator i = fieldsHistory.entrySet().iterator(); i.hasNext(); ) {
			Map.Entry entry = (Map.Entry) i.next();
			Field field = (Field) entry.getKey();
			try {
				field.set(o, entry.getValue());
			} catch (IllegalArgumentException e) {
				// empty
			} catch (IllegalAccessException e) {
				// empty
			}
		}
	}
	
	public String getName() {
		return "NAF";
	}
}
