package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;


public abstract class AbstractProxyOperator implements ObjectMutationOperator, InvocationHandler {

	private Class type;
	
	public AbstractProxyOperator(Class type) {
		this.type = type;
	}

	public boolean canMutate(Object o) {
		return o != null && type.isInterface() && (!Proxy.isProxyClass(o.getClass())) && (o.getClass().getClassLoader() != null);
	}
	
	public Object getMutation(Object o) {
		ClassLoader loader = o.getClass().getClassLoader();
		
		//Class[] interfaces = type.getInterfaces();
/*		
		// add the class itself as interfaces
		if (interfaces.length > 0) {
			Class[] allInterfaces = new Class[interfaces.length + 1];
			allInterfaces[0] = type.getClass();
			System.arraycopy(interfaces, 0, allInterfaces, 1, interfaces.length);
			interfaces = allInterfaces;
		}*/
		
		Class[] interfaces = new Class[] { type };
		
		Object proxy = Proxy.newProxyInstance(loader, interfaces, this);
		return proxy;
	}
	
	public void restore(Object o) {
		// empty - this operator returns new instances
	}
}
