package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.Method;

public abstract class AbstractCollectionsOperator implements ObjectMutationOperator {

	protected Method method;
	
	public AbstractCollectionsOperator(Method method) {
		this.method = method;
	}
	
	/**
	 * Don't mutate java runtime library classes, such as java.util.Arrays
	 */
	public boolean canMutate(Object o) {
		if (method != null) {
			String declaringClassName = method.getDeclaringClass().getName();
			return (! declaringClassName.startsWith("java.lang.")) && (! declaringClassName.startsWith("java.util."));
		}
		
		return true;
	}
}
