package pl.poznan.put.qjunit.response;


import java.util.ArrayList;
import java.util.List;

public abstract class LearningAdapter extends ResponseAdapter {

	protected List learnedResponses = new ArrayList();
	
	public void add(boolean origResponse) {
		learnedResponses.add(new Boolean(origResponse));
	}

	public void add(byte origResponse) {
		learnedResponses.add(new Byte(origResponse));
	}

	public void add(char origResponse) {
		learnedResponses.add(new Character(origResponse));
	}

	public void add(double origResponse) {
		learnedResponses.add(new Double(origResponse));
	}

	public void add(float origResponse) {
		learnedResponses.add(new Float(origResponse));
	}

	public void add(int origResponse) {
		learnedResponses.add(new Integer(origResponse));
	}

	public void add(long origResponse) {
		learnedResponses.add(new Long(origResponse));
	}

	public void add(short origResponse) {
		learnedResponses.add(new Short(origResponse));
	}

	public void add(Object origResponse) {
		learnedResponses.add(origResponse);
	}

	public Object[] getLearnedResponses() {
		return learnedResponses.toArray(new Object[learnedResponses.size()]);
	}
	
	
}
