package pl.poznan.put.qjunit.response;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

import pl.poznan.put.qjunit.response.providers.EmptyResponseProvider;
import pl.poznan.put.qjunit.response.providers.operators.AddElementToList;
import pl.poznan.put.qjunit.response.providers.operators.EmptyCollection;
import pl.poznan.put.qjunit.response.providers.operators.IteratorSkip;
import pl.poznan.put.qjunit.response.providers.operators.NullAllFields;
import pl.poznan.put.qjunit.response.providers.operators.NullAllMethodsProxy;
import pl.poznan.put.qjunit.response.providers.operators.ObjectInsteadOfNull;
import pl.poznan.put.qjunit.response.providers.operators.ObjectMutationOperator;
import pl.poznan.put.qjunit.response.providers.operators.ObjectMutationProvider;
import pl.poznan.put.qjunit.response.providers.operators.RemoveListElement;
import pl.poznan.put.qjunit.response.providers.operators.ZeroAllPrimitiveFields;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProvider;
import pl.poznan.put.qjunit.runtime.interceptor.ResponseProviderFactory;

/**
 * Produces response providers for join points
 *
 */
public class DefaultDecoratedResponseProviderFactory implements ResponseProviderFactory {
	
	public ResponseProvider createBooleanResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createCharResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createByteResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createIntResponseProvider(JoinPoint.StaticPart joinPoint) {
		//System.out.println("New");
		return new EmptyResponseProvider(); // new StaticIntResponseProvider(new int[] {0, -1, +1});
	}
	
	public ResponseProvider createFloatResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createDoubleResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createLongResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createShortResponseProvider(JoinPoint.StaticPart joinPoint) {
		return new EmptyResponseProvider();
	}
	
	public ResponseProvider createObjectResponseProvider(JoinPoint.StaticPart joinPoint) {
		List operators = new ArrayList();
		
		// null mutators
		operators.add(new NullAllFields());
		operators.add(new ZeroAllPrimitiveFields());
		
		Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
		if (method != null) {
			Class returnType = method.getReturnType();
			operators.add(new NullAllMethodsProxy(returnType));
			operators.add(new ObjectInsteadOfNull(returnType));
		}
		
		// collections mutators
		operators.add(new RemoveListElement(method));
		operators.add(new EmptyCollection(method));
		operators.add(new AddElementToList(method));
		operators.add(new IteratorSkip(method));
		
		ObjectMutationOperator[] array = (ObjectMutationOperator[])operators.toArray(new ObjectMutationOperator[operators.size()]);
		return new ObjectMutationProvider(array);
	}
}
