/*
 * Decompiled with CFR 0.152.
 */
package pl.poznan.put.qjunit.response.providers.operators;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import pl.poznan.put.qjunit.response.providers.operators.ObjectMutationOperator;
import pl.poznan.put.qjunit.response.providers.operators.OperatorsUtils;

public class ZeroAllPrimitiveFields
implements ObjectMutationOperator {
    protected Map fieldsHistory = new HashMap();

    public boolean canMutate(Object o) {
        if (o == null) {
            return false;
        }
        Class<?> clazz = o.getClass();
        if (clazz.getName().startsWith("java.lang")) {
            return false;
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            Class<?> type = fields[i].getType();
            try {
                if (type.isPrimitive() && !ZeroAllPrimitiveFields.isZero(fields[i], type, o)) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i;
        }
        return false;
    }

    public Object getMutation(Object o) {
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Class<?> type;
            if (!fields[i].isAccessible()) {
                fields[i].setAccessible(true);
            }
            if ((type = fields[i].getType()).isPrimitive()) {
                try {
                    Object value = OperatorsUtils.getPrimitive(fields[i], type, o);
                    this.fieldsHistory.put(fields[i], value);
                    ZeroAllPrimitiveFields.setZero(fields[i], type, o);
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            ++i;
        }
        return o;
    }

    protected static boolean isZero(Field field, Class type, Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (type.equals(Integer.TYPE)) {
            return field.getInt(obj) == 0;
        }
        if (type.equals(Boolean.TYPE)) {
            return !field.getBoolean(obj);
        }
        if (type.equals(Byte.TYPE)) {
            return field.getByte(obj) == 0;
        }
        if (type.equals(Character.TYPE)) {
            return field.getChar(obj) == '\u0000';
        }
        if (type.equals(Double.TYPE)) {
            return field.getDouble(obj) == 0.0;
        }
        if (type.equals(Float.TYPE)) {
            return field.getFloat(obj) == 0.0f;
        }
        if (type.equals(Long.TYPE)) {
            return field.getLong(obj) == 0L;
        }
        if (type.equals(Short.TYPE)) {
            return field.getShort(obj) == 0;
        }
        return false;
    }

    protected static void setZero(Field field, Class type, Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (type.equals(Integer.TYPE)) {
            field.setInt(obj, 0);
        } else if (type.equals(Boolean.TYPE)) {
            field.setBoolean(obj, false);
        } else if (type.equals(Byte.TYPE)) {
            field.setByte(obj, (byte)0);
        } else if (type.equals(Character.TYPE)) {
            field.setChar(obj, '\u0000');
        } else if (type.equals(Double.TYPE)) {
            field.setDouble(obj, 0.0);
        } else if (type.equals(Float.TYPE)) {
            field.setFloat(obj, 0.0f);
        } else if (type.equals(Long.TYPE)) {
            field.setLong(obj, 0L);
        } else if (type.equals(Short.TYPE)) {
            field.setShort(obj, (short)0);
        }
    }

    public void restore(Object o) {
        for (Map.Entry entry : this.fieldsHistory.entrySet()) {
            Field field = (Field)entry.getKey();
            try {
                OperatorsUtils.setPrimitive(field, field.getType(), o, entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public String getName() {
        return "ZAPF";
    }
}

