/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.query;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class QueryableMetadataRepositoryManager
implements IQueryable {
    private MetadataRepositories repositories;
    static /* synthetic */ Class class$0;

    public QueryableMetadataRepositoryManager(MetadataRepositories repositories) {
        this.repositories = repositories;
    }

    public Collector query(Query query, Collector result, IProgressMonitor monitor) {
        IMetadataRepositoryManager manager;
        ArrayList<URL> repoURLs = new ArrayList<URL>();
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            ProvUI.reportStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager), 3);
            return result;
        }
        if (this.repositories.getMetadataRepositories() != null) {
            repoURLs.addAll(Arrays.asList(this.repositories.getMetadataRepositories()));
        } else {
            repoURLs.addAll(Arrays.asList(manager.getKnownRepositories(this.repositories.getRepoFlags())));
            if (this.repositories.getIncludeDisabledRepositories()) {
                repoURLs.addAll(Arrays.asList(manager.getKnownRepositories(8)));
            }
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.QueryableMetadataRepositoryManager_RepositoryQueryProgress, (int)(repoURLs.size() * 2));
        if (sub.isCanceled()) {
            return result;
        }
        int i = 0;
        while (i < repoURLs.size()) {
            block15: {
                if (sub.isCanceled()) {
                    return result;
                }
                if (query == null) {
                    result.accept(repoURLs.get(i));
                    sub.worked(2);
                } else {
                    try {
                        IMetadataRepository repo = manager.loadRepository((URL)repoURLs.get(i), (IProgressMonitor)sub.newChild(1));
                        repo.query(query, result, (IProgressMonitor)sub.newChild(1));
                    }
                    catch (ProvisionException e) {
                        if (e.getStatus().getCode() == 1000) break block15;
                        ProvUI.handleException(e, NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, repoURLs.get(i)), 1);
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

