/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.osgi.framework.BundleContext;

public class IUPropertyUtils {
    static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    static final String NAMESPACE_IU_LOCALIZATION = "org.eclipse.equinox.p2.localization";
    static /* synthetic */ Class class$0;

    public static String getIUProperty(IInstallableUnit iu, String propertyKey, Locale locale) {
        String defaultKey;
        String defaultValue;
        IUPropertyQuery iuQuery;
        IMetadataRepositoryManager repoMgr;
        Collector collected;
        String value = iu.getProperty(propertyKey);
        if (value == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        final List locales = IUPropertyUtils.buildLocaleVariants(locale);
        final IInstallableUnit theUnit = iu;
        Collector hostLocalizationCollector = new Collector(){

            public boolean accept(Object object) {
                boolean haveHost = false;
                boolean haveLocale = false;
                if (object instanceof IInstallableUnitFragment) {
                    IInstallableUnitFragment fragment = (IInstallableUnitFragment)object;
                    RequiredCapability[] hosts = fragment.getHost();
                    int i = 0;
                    while (i < hosts.length) {
                        RequiredCapability nextHost = hosts[i];
                        if ("org.eclipse.equinox.p2.iu".equals(nextHost.getNamespace()) && theUnit.getId().equals(nextHost.getName()) && nextHost.getRange() != null && nextHost.getRange().isIncluded(theUnit.getVersion())) {
                            haveHost = true;
                            break;
                        }
                        ++i;
                    }
                    if (haveHost) {
                        ProvidedCapability[] provides = fragment.getProvidedCapabilities();
                        int j = 0;
                        while (j < provides.length && !haveLocale) {
                            String providedLocale;
                            ProvidedCapability nextProvide = provides[j];
                            if (IUPropertyUtils.NAMESPACE_IU_LOCALIZATION.equals(nextProvide.getNamespace()) && (providedLocale = nextProvide.getName()) != null) {
                                Iterator iter = locales.iterator();
                                while (iter.hasNext()) {
                                    if (!providedLocale.equals(iter.next())) continue;
                                    haveLocale = true;
                                    break;
                                }
                            }
                            ++j;
                        }
                    }
                }
                return haveHost && haveLocale ? super.accept(object) : false;
            }
        };
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(collected = (repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).query((Query)(iuQuery = new IUPropertyQuery("org.eclipse.equinox.p2.type.fragment", "true")), hostLocalizationCollector, null)).isEmpty()) {
            String translation = null;
            Iterator iter = collected.iterator();
            while (iter.hasNext() && translation == null) {
                IInstallableUnit localizationIU = (IInstallableUnit)iter.next();
                Iterator jter = locales.iterator();
                while (jter.hasNext()) {
                    String localeKey = IUPropertyUtils.makeLocalizedKey(actualKey, (String)jter.next());
                    translation = localizationIU.getProperty(localeKey);
                    if (translation == null) continue;
                    return translation;
                }
            }
        }
        if ((defaultValue = iu.getProperty(defaultKey = IUPropertyUtils.makeLocalizedKey(actualKey, DEFAULT_LOCALE.toString()))) != null) {
            return defaultValue;
        }
        return value;
    }

    private static List buildLocaleVariants(Locale locale) {
        String nl = locale.toString();
        ArrayList<Object> result = new ArrayList<Object>(4);
        while (true) {
            result.add(nl);
            int lastSeparator = nl.lastIndexOf(95);
            if (lastSeparator == -1) break;
            nl = nl.substring(0, lastSeparator);
        }
        result.add(DEFAULT_LOCALE);
        return result;
    }

    private static String makeLocalizedKey(String actualKey, String localeImage) {
        return String.valueOf(localeImage) + '.' + actualKey;
    }
}

