/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.engine.phases.Sizing;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.SizingPhaseSet;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ProvisioningUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public static void addMetadataRepository(URL location) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.addRepository(location);
    }

    public static String getMetadataRepositoryProperty(URL location, String key) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getRepositoryProperty(location, key);
    }

    public static boolean getMetadataRepositoryEnablement(URL location) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        return manager.isEnabled(location);
    }

    public static boolean getArtifactRepositoryEnablement(URL location) {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        return manager.isEnabled(location);
    }

    public static IMetadataRepository loadMetadataRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        IMetadataRepository repo = manager.loadRepository(location, monitor);
        if (repo == null) {
            throw new ProvisionException(NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, (Object)location.toExternalForm()));
        }
        return repo;
    }

    public static IStatus validateMetadataRepositoryLocation(URL location, IProgressMonitor monitor) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.validateRepositoryLocation(location, monitor);
    }

    public static URL getRollbackRepositoryURL() throws ProvisionException {
        IMetadataRepositoryManager manager;
        IDirector director = ProvisioningUtil.getDirector();
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return director.getRollbackRepositoryLocation();
    }

    public static void removeMetadataRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.removeRepository(location);
    }

    public static void addArtifactRepository(URL location) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.addRepository(location);
    }

    public static String getArtifactRepositoryProperty(URL location, String key) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getRepositoryProperty(location, key);
    }

    public static IArtifactRepository loadArtifactRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        IArtifactRepository repo = manager.loadRepository(location, monitor);
        if (repo == null) {
            throw new ProvisionException(NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, (Object)location.toExternalForm()));
        }
        return repo;
    }

    public static void removeArtifactRepository(URL location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.removeRepository(location);
    }

    public static IProfile addProfile(String profileId, Map properties, IProgressMonitor monitor) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.addProfile(profileId, properties);
    }

    public static void removeProfile(String profileId, IProgressMonitor monitor) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        profileRegistry.removeProfile(profileId);
    }

    public static IProfile[] getProfiles() throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.getProfiles();
    }

    public static IProfile getProfile(String id) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.getProfile(id);
    }

    public static URL[] getMetadataRepositories(int flags) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getKnownRepositories(flags);
    }

    public static void refreshMetadataRepositories(URL[] urls, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length * 100));
        int i = 0;
        while (i < urls.length) {
            try {
                manager.refreshRepository(urls[i], (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
    }

    public static URL[] getArtifactRepositories(int flags) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getKnownRepositories(flags);
    }

    public static void refreshArtifactRepositories(URL[] urls, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length * 100));
        int i = 0;
        while (i < urls.length) {
            manager.refreshRepository(urls[i], (IProgressMonitor)mon.newChild(100));
            ++i;
        }
    }

    public static ProvisioningPlan getProvisioningPlan(ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        return ProvisioningUtil.getPlanner().getProvisioningPlan(request, context, monitor);
    }

    public static IInstallableUnit[] updatesFor(IInstallableUnit toUpdate, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull((Object)toUpdate);
        return ProvisioningUtil.getPlanner().updatesFor(toUpdate, new ProvisioningContext(), monitor);
    }

    public static IInstallableUnit[] updatesFor(IInstallableUnit[] toUpdate, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull((Object)toUpdate);
        IPlanner planner = ProvisioningUtil.getPlanner();
        ArrayList<IInstallableUnit> allUpdates = new ArrayList<IInstallableUnit>();
        int i = 0;
        while (i < toUpdate.length) {
            IInstallableUnit[] updates = planner.updatesFor(toUpdate[i], new ProvisioningContext(), monitor);
            int j = 0;
            while (j < updates.length) {
                allUpdates.add(updates[j]);
                ++j;
            }
            ++i;
        }
        return allUpdates.toArray(new IInstallableUnit[allUpdates.size()]);
    }

    public static ProvisioningPlan getRevertPlan(IInstallableUnit profileIU, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull((Object)profileIU);
        return ProvisioningUtil.getPlanner().getRevertPlan(profileIU, new ProvisioningContext(), monitor);
    }

    public static Sizing getSizeInfo(ProvisioningPlan plan, String profileId, IProgressMonitor monitor) throws ProvisionException {
        SizingPhaseSet set = new SizingPhaseSet();
        IStatus status = ProvisioningUtil.getEngine().perform(ProvisioningUtil.getProfile(profileId), (PhaseSet)set, plan.getOperands(), null, monitor);
        if (status.isOK()) {
            return set.getSizing();
        }
        return null;
    }

    public static IStatus performProvisioningPlan(ProvisioningPlan plan, PhaseSet phaseSet, IProfile profile, IProgressMonitor monitor) throws ProvisionException {
        Object set = phaseSet == null ? new DefaultPhaseSet() : phaseSet;
        return ProvisioningUtil.getEngine().perform(profile, set, plan.getOperands(), null, monitor);
    }

    private static IEngine getEngine() throws ProvisionException {
        IEngine engine = (IEngine)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoEngineFound);
        }
        return engine;
    }

    public static IPlanner getPlanner() throws ProvisionException {
        IPlanner planner;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoPlannerFound);
        }
        return planner;
    }

    public static IDirector getDirector() throws ProvisionException {
        IDirector director;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoDirectorFound);
        }
        return director;
    }

    public static void setColocatedRepositoryEnablement(URL location, boolean enabled) {
        IArtifactRepositoryManager artifactManager;
        IMetadataRepositoryManager metaManager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((metaManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            metaManager.setEnabled(location, enabled);
        }
        BundleContext bundleContext2 = ProvUIActivator.getContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName())) != null) {
            artifactManager.setEnabled(location, enabled);
        }
    }

    public static boolean isCategory(IInstallableUnit iu) {
        String isCategory = iu.getProperty("org.eclipse.equinox.p2.type.category");
        return isCategory != null && Boolean.valueOf(isCategory) != false;
    }
}

