/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.osgi.util.NLS;

public abstract class URLValidator {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file:";
    public static final String JAR_PATH_PREFIX = "jar:";
    public static final String JAR_PATH_SUFFIX = "!/";
    public static final String JAR_EXTENSION = ".jar";
    public static final String ZIP_EXTENSION = ".zip";
    public static final int LOCAL_VALIDATION_ERROR = 3000;
    public static final int REPO_AUTO_GENERATED = 3001;
    public static final int ALTERNATE_ACTION_TAKEN = 3002;

    public static Status getInvalidURLStatus(String urlText) {
        return new Status(4, "org.eclipse.equinox.p2.ui", 3000, NLS.bind((String)ProvUIMessages.URLValidator_UnrecognizedURL, (Object)urlText), null);
    }

    public static boolean isFileURL(URL url) {
        return url.getProtocol().equals(FILE_PROTOCOL);
    }

    public static String makeJarURLString(String path) {
        String lowerCase = path.toLowerCase();
        if (lowerCase.endsWith(JAR_EXTENSION) || lowerCase.endsWith(ZIP_EXTENSION)) {
            return "jar:file:" + path + JAR_PATH_SUFFIX;
        }
        return URLValidator.makeFileURLString(path);
    }

    public static String makeFileURLString(String path) {
        StringBuffer result = new StringBuffer(path.length() + 6);
        result.append(FILE_PROTOCOL_PREFIX);
        if (path.length() == 0 || path.charAt(0) != '/') {
            result.append('/');
        }
        result.append(path);
        return result.toString();
    }

    protected abstract IStatus validateRepositoryURL(URL var1, boolean var2, IProgressMonitor var3);
}

