/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.ui.IRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLDropAdapter;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.WorkbenchJob;

public class RepositoryManipulatorDropTarget
extends URLDropAdapter {
    IRepositoryManipulator manipulator;
    Control control;

    public RepositoryManipulatorDropTarget(IRepositoryManipulator manipulator, Control control) {
        super(true);
        Assert.isNotNull((Object)manipulator);
        this.manipulator = manipulator;
        this.control = control;
    }

    protected void handleDrop(String urlText, final DropTargetEvent event) {
        event.detail = 0;
        final URL[] url = new URL[1];
        try {
            url[0] = new URL(urlText);
        }
        catch (MalformedURLException malformedURLException) {
            ProvUI.reportStatus((IStatus)URLValidator.getInvalidURLStatus(urlText), 3);
            return;
        }
        if (url[0] == null) {
            return;
        }
        WorkbenchJob job = new WorkbenchJob(NLS.bind((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragAndDropJobLabel, (Object)this.manipulator.getAddOperationLabel())){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStatus status = RepositoryManipulatorDropTarget.this.manipulator.getURLValidator(RepositoryManipulatorDropTarget.this.control.getShell()).validateRepositoryURL(url[0], true, monitor);
                if (status.isOK()) {
                    ProvisioningOperation addOperation = RepositoryManipulatorDropTarget.this.manipulator.getAddOperation(url[0]);
                    ProvisioningOperationRunner.schedule(addOperation, RepositoryManipulatorDropTarget.this.control.getShell(), 3);
                    event.detail = 4;
                } else if (status.getCode() == 3001 || status.getCode() == 3002) {
                    event.detail = 1;
                } else if (status.getSeverity() == 8) {
                    event.detail = 0;
                } else {
                    status = new MultiStatus("org.eclipse.equinox.p2.ui", 0, new IStatus[]{status}, NLS.bind((String)ProvUIMessages.RepositoryManipulatorDropTarget_DragSourceNotValid, (Object)url[0].toExternalForm()), null);
                    event.detail = 0;
                }
                return status;
            }
        };
        job.setPriority(20);
        job.setUser(true);
        job.schedule();
    }
}

