/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.DeferredFetchFilteredTree;
import org.eclipse.equinox.internal.p2.ui.dialogs.StructuredIUGroup;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AvailableIUPatternFilter;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.IViewMenuProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IRepositoryElement;
import org.eclipse.equinox.internal.provisional.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RefreshMetadataRepositoriesOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.IQueryProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.ui.query.QueryContext;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class AvailableIUGroup
extends StructuredIUGroup {
    QueryContext queryContext;
    AvailableIUPatternFilter filter;
    private IViewMenuProvider menuProvider;
    private boolean useBold = false;
    private boolean useCheckboxes = false;
    private IUDetailsLabelProvider labelProvider;
    private Display display;
    boolean ignoreEvent = false;
    DeferredFetchFilteredTree filteredTree;
    IUColumnConfig[] columnConfig;
    private int refreshRepoFlags = 2;
    ISelectionProvider selectionProvider;

    public AvailableIUGroup(Composite parent, IQueryProvider queryProvider, Font font, ProvisioningContext context) {
        this(parent, queryProvider, font, context, null, null, ProvUI.getIUColumnConfig(), null, false);
    }

    public AvailableIUGroup(Composite parent, IQueryProvider queryProvider, Font font, ProvisioningContext context, QueryContext queryContext, AvailableIUPatternFilter filter, IUColumnConfig[] columnConfig, IViewMenuProvider menuProvider, boolean useCheckboxes) {
        super(parent, queryProvider, font, context);
        this.display = parent.getDisplay();
        this.queryContext = queryContext;
        this.filter = filter;
        this.menuProvider = menuProvider;
        this.useCheckboxes = useCheckboxes;
        this.columnConfig = columnConfig == null ? ProvUI.getIUColumnConfig() : columnConfig;
        this.filter = filter == null ? new AvailableIUPatternFilter(this.columnConfig) : filter;
        this.createGroupComposite(parent);
    }

    protected StructuredViewer createViewer(Composite parent) {
        this.filteredTree = new DeferredFetchFilteredTree(parent, 68354, this.filter, this.menuProvider, parent.getDisplay(), this.useCheckboxes);
        TreeViewer availableIUViewer = this.filteredTree.getViewer();
        this.selectionProvider = availableIUViewer instanceof CheckboxTreeViewer ? new CheckSelectionProvider((CheckboxTreeViewer)availableIUViewer) : availableIUViewer;
        this.labelProvider = new IUDetailsLabelProvider(this.filteredTree, this.columnConfig, this.getShell());
        this.labelProvider.setUseBoldFontForFilteredItems(this.useBold);
        this.labelProvider.setToolTipProperty("org.eclipse.equinox.p2.description");
        availableIUViewer.setComparator((ViewerComparator)new IUComparator(0));
        availableIUViewer.setComparer((IElementComparer)new ProvElementComparer());
        DeferredQueryContentProvider contentProvider = new DeferredQueryContentProvider(this.getQueryProvider());
        availableIUViewer.setContentProvider((IContentProvider)contentProvider);
        this.setTreeColumns(availableIUViewer.getTree());
        availableIUViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.filteredTree.contentProviderSet(contentProvider);
        availableIUViewer.setInput(this.getNewInput());
        final StructuredViewerProvisioningListener listener = new StructuredViewerProvisioningListener((StructuredViewer)availableIUViewer, 1, this.getQueryProvider()){

            protected void repositoryAdded(RepositoryEvent event) {
                if (AvailableIUGroup.this.ignoreEvent) {
                    AvailableIUGroup.this.ignoreEvent = false;
                    return;
                }
                AvailableIUGroup.this.makeRepositoryVisible(event.getRepositoryLocation());
            }

            protected void repositoryDiscovered(RepositoryEvent event) {
                AvailableIUGroup.this.ignoreEvent = true;
            }
        };
        ProvUIActivator.getDefault().addProvisioningListener(listener);
        availableIUViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ProvUIActivator.getDefault().removeProvisioningListener(listener);
            }
        });
        return availableIUViewer;
    }

    private void setTreeColumns(Tree tree) {
        tree.setHeaderVisible(true);
        int i = 0;
        while (i < this.columnConfig.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(this.columnConfig[i].columnTitle);
            tc.setWidth(this.convertHorizontalDLUsToPixels(this.columnConfig[i].defaultColumnWidth));
            ++i;
        }
    }

    Object getNewInput() {
        MetadataRepositories input = new MetadataRepositories(this.getProvisioningContext().getMetadataRepositories());
        input.setQueryContext(this.queryContext);
        input.setQueryProvider(this.getQueryProvider());
        return input;
    }

    public void setQueryContext(QueryContext context) {
        this.queryContext = context;
        if (this.viewer == null) {
            return;
        }
        Object input = this.viewer.getInput();
        if (input instanceof QueriedElement) {
            ((QueriedElement)input).setQueryContext(context);
            this.viewer.refresh();
        }
    }

    public void setRepositoryRefreshFlags(int flags) {
        this.refreshRepoFlags = flags;
    }

    public void setUseBoldFontForFilteredItems(boolean useBoldFont) {
        if (this.labelProvider != null) {
            this.labelProvider.setUseBoldFontForFilteredItems(useBoldFont);
        }
    }

    public Composite getComposite() {
        return super.getComposite();
    }

    public StructuredViewer getStructuredViewer() {
        return super.getStructuredViewer();
    }

    public IInstallableUnit[] getSelectedIUs() {
        return super.getSelectedIUs();
    }

    public Tree getTree() {
        if (this.viewer == null) {
            return null;
        }
        return ((TreeViewer)this.viewer).getTree();
    }

    public void refresh() {
        URL[] urls = this.getProvisioningContext().getMetadataRepositories();
        RefreshMetadataRepositoriesOperation op = urls == null ? new RefreshMetadataRepositoriesOperation(ProvUIMessages.AvailableIUGroup_RefreshOperationLabel, this.refreshRepoFlags) : new RefreshMetadataRepositoriesOperation(ProvUIMessages.AvailableIUGroup_RefreshOperationLabel, urls);
        ProvisioningOperationRunner.schedule(op, this.getShell(), 3);
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.setInput(this.getNewInput());
        }
    }

    void makeRepositoryVisible(final URL location) {
        try {
            ProvisioningUtil.loadMetadataRepository(location, null);
        }
        catch (ProvisionException provisionException) {}
        this.display.asyncExec(new Runnable(){

            public void run() {
                TreeViewer treeViewer = AvailableIUGroup.this.filteredTree.getViewer();
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench.isClosing()) {
                    return;
                }
                treeViewer.refresh();
                Tree tree = treeViewer.getTree();
                if (tree != null && !tree.isDisposed()) {
                    TreeItem[] items = tree.getItems();
                    int i = 0;
                    while (i < items.length) {
                        URL url;
                        if (items[i].getData() instanceof IRepositoryElement && (url = ((IRepositoryElement)items[i].getData()).getLocation()).toExternalForm().equals(location.toExternalForm())) {
                            treeViewer.expandToLevel(items[i].getData(), -1);
                            tree.select(items[i]);
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    public ISelectionProvider getCheckMappingSelectionProvider() {
        return this.selectionProvider;
    }

    class CheckSelectionProvider
    implements ISelectionProvider,
    ICheckStateListener {
        CheckboxTreeViewer checkboxViewer;
        private ListenerList listeners = new ListenerList();
        List checkedNotGrayed;

        CheckSelectionProvider(CheckboxTreeViewer v) {
            this.checkboxViewer = v;
            v.addCheckStateListener((ICheckStateListener)this);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public ISelection getSelection() {
            return new IStructuredSelection(this){
                final /* synthetic */ CheckSelectionProvider this$1;
                {
                    this.this$1 = checkSelectionProvider;
                }

                public Object getFirstElement() {
                    if (this.size() == 0) {
                        return null;
                    }
                    return this.toList().get(0);
                }

                public Iterator iterator() {
                    return this.toList().iterator();
                }

                public int size() {
                    return this.toList().size();
                }

                public Object[] toArray() {
                    return this.toList().toArray();
                }

                public List toList() {
                    return this.this$1.getCheckedNotGrayed();
                }

                public boolean isEmpty() {
                    return this.toList().isEmpty();
                }
            };
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                this.checkboxViewer.setCheckedElements(((IStructuredSelection)selection).toArray());
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object[] listenerArray = this.listeners.getListeners();
            this.checkedNotGrayed = null;
            SelectionChangedEvent selectionEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            int i = 0;
            while (i < listenerArray.length) {
                ((ISelectionChangedListener)listenerArray[i]).selectionChanged(selectionEvent);
                ++i;
            }
        }

        List getCheckedNotGrayed() {
            if (this.checkedNotGrayed == null) {
                Object[] checked = this.checkboxViewer.getCheckedElements();
                this.checkedNotGrayed = new ArrayList(checked.length);
                int i = 0;
                while (i < checked.length) {
                    if (!this.checkboxViewer.getGrayed(checked[i])) {
                        this.checkedNotGrayed.add(checked[i]);
                    }
                    ++i;
                }
            }
            return this.checkedNotGrayed;
        }
    }
}

