/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.dialogs;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.DefaultMetadataURLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.TextURLDropAdapter;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AddRepositoryDialog
extends StatusDialog {
    Button okButton;
    Text url;
    URLValidator urlValidator;
    static final String[] ARCHIVE_EXTENSIONS = new String[]{"*.jar;*.zip"};
    static String lastLocalLocation = null;
    static String lastArchiveLocation = null;
    protected int repoFlag;

    public AddRepositoryDialog(Shell parentShell, int repoFlag) {
        super(parentShell);
        this.repoFlag = repoFlag;
        this.urlValidator = this.createURLValidator();
        this.setTitle(ProvUIMessages.AddRepositoryDialog_Title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.initializeDialogUnits((Control)comp);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        comp.setLayoutData((Object)data);
        Label urlLabel = new Label(comp, 0);
        urlLabel.setText(ProvUIMessages.RepositoryPropertyPage_URLFieldLabel);
        this.url = new Text(comp, 2048);
        data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.url.setLayoutData((Object)data);
        DropTarget target = new DropTarget((Control)this.url, 7);
        target.setTransfer(new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new TextURLDropAdapter(this.url, true));
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddRepositoryDialog.this.validateRepositoryURL(false);
            }
        });
        this.url.setText("http://");
        this.url.setSelection(0, this.url.getText().length());
        Composite buttonParent = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonParent.setLayout((Layout)layout);
        Button locationButton = new Button(buttonParent, 8);
        locationButton.setText(ProvUIMessages.RepositoryGroup_LocalRepoBrowseButton);
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(AddRepositoryDialog.this.getShell(), 65536);
                dialog.setMessage(ProvUIMessages.RepositoryGroup_SelectRepositoryDirectory);
                dialog.setFilterPath(lastLocalLocation);
                String path = dialog.open();
                if (path != null) {
                    lastLocalLocation = path;
                    AddRepositoryDialog.this.url.setText(URLValidator.makeFileURLString(path));
                    AddRepositoryDialog.this.validateRepositoryURL(false);
                }
            }
        });
        this.setButtonLayoutData(locationButton);
        locationButton = new Button(buttonParent, 8);
        locationButton.setText(ProvUIMessages.RepositoryGroup_ArchivedRepoBrowseButton);
        locationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(AddRepositoryDialog.this.getShell(), 65536);
                dialog.setText(ProvUIMessages.RepositoryGroup_RepositoryFile);
                dialog.setFilterExtensions(ARCHIVE_EXTENSIONS);
                dialog.setFileName(lastArchiveLocation);
                String path = dialog.open();
                if (path != null) {
                    lastArchiveLocation = path;
                    AddRepositoryDialog.this.url.setText(URLValidator.makeJarURLString(path));
                    AddRepositoryDialog.this.validateRepositoryURL(false);
                }
            }
        });
        this.setButtonLayoutData(locationButton);
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected URLValidator createURLValidator() {
        DefaultMetadataURLValidator validator = new DefaultMetadataURLValidator();
        validator.setKnownRepositoriesFlag(this.repoFlag);
        return validator;
    }

    protected URLValidator getURLValidator() {
        return this.urlValidator;
    }

    protected void okPressed() {
        IStatus status = this.addRepository();
        if (status.isOK()) {
            super.okPressed();
        }
    }

    protected URL getUserURL() {
        URL userURL;
        try {
            userURL = new URL(this.url.getText().trim());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return userURL;
    }

    protected IStatus addRepository() {
        IStatus status = this.validateRepositoryURL(false);
        if (status.isOK()) {
            ProvisioningOperationRunner.schedule(this.getOperation(this.getUserURL()), this.getShell(), 3);
        }
        return status;
    }

    protected abstract ProvisioningOperation getOperation(URL var1);

    protected IStatus validateRepositoryURL(final boolean contactRepositories) {
        if (this.url == null || this.url.isDisposed()) {
            return Status.OK_STATUS;
        }
        final IStatus[] status = new IStatus[]{URLValidator.getInvalidURLStatus(this.url.getText().trim())};
        final URL userURL = this.getUserURL();
        if (this.url.getText().length() == 0) {
            status[0] = new Status(4, "org.eclipse.equinox.p2.ui", 3000, ProvUIMessages.RepositoryGroup_URLRequired, null);
        } else if (userURL == null) {
            status[0] = new Status(4, "org.eclipse.equinox.p2.ui", 3000, ProvUIMessages.AddRepositoryDialog_InvalidURL, null);
        } else {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    status[0] = AddRepositoryDialog.this.getURLValidator().validateRepositoryURL(userURL, contactRepositories, null);
                }
            });
        }
        if (status[0].getSeverity() == 8) {
            this.cancelPressed();
        }
        this.setOkEnablement(status[0].isOK());
        this.updateStatus(status[0]);
        return status[0];
    }

    protected void updateButtonsEnableState(IStatus status) {
        this.setOkEnablement(!status.matches(4));
    }

    private void setOkEnablement(boolean enable) {
        if (this.okButton != null && !this.okButton.isDisposed()) {
            this.okButton.setEnabled(enable);
        }
    }
}

