/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IProfileChooser;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policies;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class UninstallAction
extends ProfileModificationAction {
    public UninstallAction(ISelectionProvider selectionProvider, String profileId, IProfileChooser chooser, Policies policies, Shell shell) {
        super(ProvUI.UNINSTALL_COMMAND_LABEL, selectionProvider, profileId, chooser, policies, shell);
        this.setToolTipText(ProvUI.UNINSTALL_COMMAND_TOOLTIP);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        Object parent = null;
        IProfile profile = this.getProfile(false);
        if (profile == null) {
            return false;
        }
        if (selectionArray.length > 0) {
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof InstalledIUElement) {
                    InstalledIUElement element = (InstalledIUElement)selectionArray[i];
                    int lock = this.getLock(profile, element.getIU());
                    if ((lock & 1) == 1) {
                        return false;
                    }
                    if (parent == null) {
                        parent = element.getParent(null);
                    } else if (parent != element.getParent(null)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected String getTaskName() {
        return ProvUIMessages.UninstallIUProgress;
    }

    protected void performOperation(IInstallableUnit[] ius, String targetProfileId, ProvisioningPlan plan) {
        UninstallWizard wizard = new UninstallWizard(targetProfileId, ius, plan);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.open();
    }

    protected ProvisioningPlan getProvisioningPlan(IInstallableUnit[] ius, String targetProfileId, IProgressMonitor monitor) throws ProvisionException {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)targetProfileId);
        request.removeInstallableUnits(ius);
        return ProvisioningUtil.getProvisioningPlan(request, new ProvisioningContext(), monitor);
    }
}

